/*
 * Decompiled with CFR 0.152.
 */
package generic.json;

import generic.json.JSONError;
import generic.json.JSONToken;
import generic.json.JSONType;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JSONParser {
    static boolean JSMN_STRICT = false;
    int pos = 0;
    int toknext = 0;
    int toksuper = -1;
    int ndx = 0;

    JSONToken allocateToken(List<JSONToken> tokens, JSONType type, int start, int end) {
        JSONToken token = new JSONToken(type, start, end);
        tokens.add(token);
        this.toknext = tokens.size();
        return token;
    }

    JSONError parsePrimitive(char[] js, List<JSONToken> tokens) {
        int start = this.pos;
        boolean found = false;
        if (JSMN_STRICT) {
            while (js[this.pos] != '\u0000') {
                switch (js[this.pos]) {
                    case ',': 
                    case ']': 
                    case '}': {
                        found = true;
                    }
                }
                if (found) break;
                if (js[this.pos] < ' ') {
                    this.pos = start;
                    return JSONError.JSMN_ERROR_INVAL;
                }
                ++this.pos;
            }
            if (!found) {
                this.pos = start;
                return JSONError.JSMN_ERROR_PART;
            }
        } else {
            while (js[this.pos] != '\u0000') {
                switch (js[this.pos]) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case ':': 
                    case ']': 
                    case '}': {
                        found = true;
                    }
                }
                if (found) break;
                if (js[this.pos] < ' ') {
                    this.pos = start;
                    return JSONError.JSMN_ERROR_INVAL;
                }
                ++this.pos;
            }
        }
        this.allocateToken(tokens, JSONType.JSMN_PRIMITIVE, start, this.pos);
        --this.pos;
        return JSONError.JSMN_SUCCESS;
    }

    JSONError parseString(char[] js, List<JSONToken> tokens) {
        int start = this.pos++;
        while (this.pos < js.length) {
            char c = js[this.pos];
            if (c == '\"') {
                this.allocateToken(tokens, JSONType.JSMN_STRING, start + 1, this.pos);
                return JSONError.JSMN_SUCCESS;
            }
            if (c == '\\') {
                ++this.pos;
                switch (js[this.pos]) {
                    case '\"': 
                    case '/': 
                    case '\\': 
                    case 'b': 
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': {
                        break;
                    }
                    case 'u': {
                        for (int i = 0; i < 4; ++i) {
                            ++this.pos;
                            if (JSONParser.isxdigit(js[this.pos])) continue;
                            this.pos = start;
                            return JSONError.JSMN_ERROR_INVAL;
                        }
                        break;
                    }
                    default: {
                        this.pos = start;
                        return JSONError.JSMN_ERROR_INVAL;
                    }
                }
            }
            ++this.pos;
        }
        this.pos = start;
        return JSONError.JSMN_ERROR_PART;
    }

    public JSONError parse(char[] js, List<JSONToken> tokens) {
        int i;
        while (this.pos < js.length) {
            char c = js[this.pos];
            block0 : switch (c) {
                case '[': 
                case '{': {
                    JSONToken token = this.allocateToken(tokens, c == '{' ? JSONType.JSMN_OBJECT : JSONType.JSMN_ARRAY, this.pos, -1);
                    if (this.toksuper != -1) {
                        tokens.get(this.toksuper).incSize();
                    }
                    this.toksuper = this.toknext - 1;
                    break;
                }
                case ']': 
                case '}': {
                    JSONToken token;
                    JSONType type = c == '}' ? JSONType.JSMN_OBJECT : JSONType.JSMN_ARRAY;
                    for (i = this.toknext - 1; i >= 0; --i) {
                        token = tokens.get(i);
                        if (token.start == -1 || token.end != -1) continue;
                        if (token.type != type) {
                            return JSONError.JSMN_ERROR_INVAL;
                        }
                        this.toksuper = -1;
                        token.end = this.pos + 1;
                        break;
                    }
                    if (i == -1) {
                        return JSONError.JSMN_ERROR_INVAL;
                    }
                    while (i >= 0) {
                        token = tokens.get(i);
                        if (token.start != -1 && token.end == -1) {
                            this.toksuper = i;
                            break block0;
                        }
                        --i;
                    }
                    break;
                }
                case '\"': {
                    JSONError r = this.parseString(js, tokens);
                    if (r != JSONError.JSMN_SUCCESS) {
                        return r;
                    }
                    if (this.toksuper == -1) break;
                    tokens.get(this.toksuper).incSize();
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': {
                    break;
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'f': 
                case 'n': 
                case 't': {
                    JSONError r = this.parsePrimitive(js, tokens);
                    if (r != JSONError.JSMN_SUCCESS) {
                        return r;
                    }
                    if (this.toksuper == -1) break;
                    tokens.get(this.toksuper).incSize();
                    break;
                }
                default: {
                    JSONError r;
                    if (JSMN_STRICT) {
                        r = this.parsePrimitive(js, tokens);
                        if (r != JSONError.JSMN_SUCCESS) {
                            return r;
                        }
                        if (this.toksuper == -1) break;
                        tokens.get(this.toksuper).incSize();
                        break;
                    }
                    return JSONError.JSMN_ERROR_INVAL;
                }
            }
            ++this.pos;
        }
        for (i = this.toknext - 1; i >= 0; --i) {
            JSONToken test = tokens.get(i);
            if (test.start == -1 || test.end != -1) continue;
            return JSONError.JSMN_ERROR_PART;
        }
        return JSONError.JSMN_SUCCESS;
    }

    String expands(String s) {
        return s;
    }

    public Object convert(char[] s, List<JSONToken> t) {
        HashMap<Object, Object> rv = null;
        if (this.ndx == t.size()) {
            System.out.println("array overflow in JSON parser");
        }
        JSONToken tp = t.get(this.ndx++);
        String tstr = new String(s, tp.start, tp.end - tp.start);
        block0 : switch (tp.type) {
            case JSMN_OBJECT: {
                HashMap<Object, Object> tab = new HashMap<Object, Object>();
                if (tp.size % 2 != 0) {
                    Msg.error((Object)this, (Object)"invalid json object");
                    return null;
                }
                for (int i = 0; i < tp.size / 2; ++i) {
                    Object k = this.convert(s, t);
                    Object v = this.convert(s, t);
                    tab.put(k, v);
                }
                rv = tab;
                break;
            }
            case JSMN_ARRAY: {
                ArrayList<Object> l = new ArrayList<Object>();
                for (int i = 0; i < tp.size; ++i) {
                    l.add(this.convert(s, t));
                }
                rv = l;
                break;
            }
            case JSMN_PRIMITIVE: {
                int i = tp.start;
                switch (s[tp.start]) {
                    case 't': {
                        Msg.error((Object)this, (Object)("what is this? " + tstr));
                        break block0;
                    }
                    case 'f': {
                        Msg.error((Object)this, (Object)("what is this? " + tstr));
                        break block0;
                    }
                    case 'n': {
                        break block0;
                    }
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        rv = NumericUtilities.parseLong(tstr);
                        break block0;
                    }
                }
                Msg.error((Object)this, (Object)("invalid json primitive: " + tstr));
                return null;
            }
            case JSMN_STRING: {
                rv = this.expands(tstr);
                if (rv != null) break;
                Msg.error((Object)this, (Object)("invalid json string: " + tstr));
                break;
            }
            default: {
                throw new RuntimeException("invalid json type: " + tp.type);
            }
        }
        return rv;
    }

    private static boolean isxdigit(char b) {
        switch (b) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }
}

