/*
 * Decompiled with CFR 0.152.
 */
package generic.platform;

import generic.platform.AbstractMacHandler;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.util.Msg;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.lang3.reflect.MethodUtils;

public abstract class MacAboutHandler
extends AbstractMacHandler {
    public MacAboutHandler() {
        this.addAboutApplicationListener();
    }

    public abstract void about();

    private void addAboutApplicationListener() {
        if (Platform.CURRENT_PLATFORM.getOperatingSystem() != OperatingSystem.MAC_OS_X) {
            return;
        }
        try {
            Object application = this.getApplication();
            this.setAboutHandler(application);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)"Unable to install Mac quit handler", (Throwable)e);
        }
    }

    private void setAboutHandler(Object application) throws Exception {
        Class<?> aboutHandlerClass = Class.forName("com.apple.eawt.AboutHandler");
        Object aboutHandler = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{aboutHandlerClass}, (InvocationHandler)this);
        MethodUtils.invokeMethod((Object)application, (String)"setAboutHandler", (Object[])new Object[]{aboutHandler});
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.about();
        return null;
    }
}

