/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.graph;

import ghidra.util.exception.NoValueException;
import ghidra.util.graph.AddableLongIntHashtable;
import ghidra.util.graph.DirectedGraph;
import ghidra.util.graph.Edge;
import ghidra.util.graph.GraphIterator;
import ghidra.util.graph.KeyIndexableSet;
import ghidra.util.graph.Vertex;
import ghidra.util.graph.VertexSet;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;

class EdgeSet
implements KeyIndexableSet<Edge> {
    private final DirectedGraph parentGraph;
    private long modificationNumber;
    private int capacity;
    private int nextIndex;
    private AddableLongIntHashtable edgeIndices;
    private Edge[] edges;
    private Edge[] previousEdgeWithSameFrom;
    private Edge[] previousEdgeWithSameTo;
    private Edge[] nextEdgeWithSameFrom;
    private Edge[] nextEdgeWithSameTo;

    EdgeSet(DirectedGraph parent, int capacity) {
        if (capacity < 10) {
            capacity = 10;
        }
        this.parentGraph = parent;
        this.modificationNumber = 0L;
        this.capacity = capacity;
        this.nextIndex = 0;
        this.edgeIndices = new AddableLongIntHashtable(capacity);
        this.edges = new Edge[capacity];
        this.previousEdgeWithSameFrom = new Edge[capacity];
        this.previousEdgeWithSameTo = new Edge[capacity];
        this.nextEdgeWithSameFrom = new Edge[capacity];
        this.nextEdgeWithSameTo = new Edge[capacity];
    }

    Edge getByIndex(int index) {
        return this.edges[index];
    }

    @Override
    public boolean remove(Edge e) {
        if (e == null) {
            return false;
        }
        VertexSet vertices = this.parentGraph.vertices();
        Edge oldNextEdgeWithSameFrom = this.getNextEdgeWithSameFrom(e);
        Edge oldNextEdgeWithSameTo = this.getNextEdgeWithSameTo(e);
        Edge oldPreviousEdgeWithSameFrom = this.getPreviousEdgeWithSameFrom(e);
        Edge oldPreviousEdgeWithSameTo = this.getPreviousEdgeWithSameTo(e);
        Vertex from = e.from();
        Vertex to = e.to();
        Edge firstOutgoingEdgeOfFrom = vertices.getFirstOutgoingEdge(from);
        Edge firstIncomingEdgeOfTo = vertices.getFirstIncomingEdge(to);
        Edge lastOutgoingEdgeOfFrom = vertices.getLastOutgoingEdge(from);
        Edge lastIncomingEdgeOfTo = vertices.getLastIncomingEdge(to);
        if (e.equals(firstOutgoingEdgeOfFrom)) {
            vertices.setFirstOutgoingEdge(from, oldNextEdgeWithSameFrom);
        }
        if (e.equals(lastOutgoingEdgeOfFrom)) {
            vertices.setLastOutgoingEdge(from, oldPreviousEdgeWithSameFrom);
        }
        if (e.equals(firstIncomingEdgeOfTo)) {
            vertices.setFirstIncomingEdge(to, oldNextEdgeWithSameTo);
        }
        if (e.equals(lastIncomingEdgeOfTo)) {
            vertices.setLastIncomingEdge(to, oldPreviousEdgeWithSameTo);
        }
        if (oldNextEdgeWithSameFrom != null) {
            this.setPreviousEdgeWithSameFrom(oldNextEdgeWithSameFrom, oldPreviousEdgeWithSameFrom);
        }
        if (oldPreviousEdgeWithSameFrom != null) {
            this.setNextEdgeWithSameFrom(oldPreviousEdgeWithSameFrom, oldNextEdgeWithSameFrom);
        }
        if (oldNextEdgeWithSameTo != null) {
            this.setPreviousEdgeWithSameTo(oldNextEdgeWithSameTo, oldPreviousEdgeWithSameTo);
        }
        if (oldPreviousEdgeWithSameTo != null) {
            this.setNextEdgeWithSameTo(oldPreviousEdgeWithSameTo, oldNextEdgeWithSameTo);
        }
        this.setPreviousEdgeWithSameFrom(e, null);
        this.setNextEdgeWithSameFrom(e, null);
        this.setPreviousEdgeWithSameTo(e, null);
        this.setNextEdgeWithSameTo(e, null);
        try {
            int index = this.edgeIndices.get(e.key());
            this.edges[index] = null;
            this.edgeIndices.remove(e.key());
            ++this.modificationNumber;
            return true;
        }
        catch (NoValueException noValueException) {
            return false;
        }
    }

    @Override
    public boolean add(Edge e) {
        Edge oldLastOutgoingEdge;
        if (this.contains(e)) {
            return false;
        }
        if (this.nextIndex >= this.capacity) {
            this.grow();
        }
        this.edges[this.nextIndex] = e;
        this.edgeIndices.add(e.key(), this.nextIndex++);
        VertexSet vertices = this.parentGraph.vertices();
        Vertex from = e.from();
        Vertex to = e.to();
        if (!vertices.contains(from)) {
            vertices.add(from);
        }
        if (!vertices.contains(to)) {
            vertices.add(to);
        }
        if ((oldLastOutgoingEdge = vertices.getLastOutgoingEdge(from)) == null) {
            vertices.setFirstOutgoingEdge(from, e);
            vertices.setLastOutgoingEdge(from, e);
        } else {
            vertices.setLastOutgoingEdge(from, e);
            this.setNextEdgeWithSameFrom(oldLastOutgoingEdge, e);
            this.setPreviousEdgeWithSameFrom(e, oldLastOutgoingEdge);
        }
        Edge oldLastIncomingEdge = vertices.getLastIncomingEdge(to);
        if (oldLastIncomingEdge == null) {
            vertices.setFirstIncomingEdge(to, e);
            vertices.setLastIncomingEdge(to, e);
        } else {
            vertices.setLastIncomingEdge(to, e);
            this.setNextEdgeWithSameTo(oldLastIncomingEdge, e);
            this.setPreviousEdgeWithSameTo(e, oldLastIncomingEdge);
        }
        ++this.modificationNumber;
        return true;
    }

    @Override
    public boolean contains(Edge edge) {
        return this.edgeIndices.contains(edge.key());
    }

    int index(Edge e) {
        try {
            return this.edgeIndices.get(e.key());
        }
        catch (NoValueException exc) {
            return -1;
        }
    }

    Edge getNextEdgeWithSameFrom(Edge e) {
        int indexOfEdge = this.index(e);
        if (indexOfEdge >= 0) {
            return this.nextEdgeWithSameFrom[indexOfEdge];
        }
        return null;
    }

    Edge getNextEdgeWithSameTo(Edge e) {
        int indexOfEdge = this.index(e);
        if (indexOfEdge >= 0) {
            return this.nextEdgeWithSameTo[indexOfEdge];
        }
        return null;
    }

    Edge getPreviousEdgeWithSameFrom(Edge e) {
        int indexOfEdge = this.index(e);
        if (indexOfEdge >= 0) {
            return this.previousEdgeWithSameFrom[indexOfEdge];
        }
        return null;
    }

    Edge getPreviousEdgeWithSameTo(Edge e) {
        int indexOfEdge = this.index(e);
        if (indexOfEdge >= 0) {
            return this.previousEdgeWithSameTo[indexOfEdge];
        }
        return null;
    }

    private void setNextEdgeWithSameFrom(Edge e, Edge nextEdge) {
        this.nextEdgeWithSameFrom[this.index((Edge)e)] = nextEdge;
    }

    private void setNextEdgeWithSameTo(Edge e, Edge nextEdge) {
        this.nextEdgeWithSameTo[this.index((Edge)e)] = nextEdge;
    }

    private void setPreviousEdgeWithSameFrom(Edge e, Edge previousEdge) {
        this.previousEdgeWithSameFrom[this.index((Edge)e)] = previousEdge;
    }

    private void setPreviousEdgeWithSameTo(Edge e, Edge previousEdge) {
        this.previousEdgeWithSameTo[this.index((Edge)e)] = previousEdge;
    }

    @Override
    public int size() {
        return this.edgeIndices.size();
    }

    public void clear() {
        if (this.size() > 0) {
            this.edgeIndices.removeAll();
            for (int i = 0; i < this.capacity; ++i) {
                this.edges[i] = null;
                this.previousEdgeWithSameFrom[i] = null;
                this.previousEdgeWithSameTo[i] = null;
                this.nextEdgeWithSameFrom[i] = null;
                this.nextEdgeWithSameTo[i] = null;
            }
        }
        this.nextIndex = 0;
        ++this.modificationNumber;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    void grow() {
        int newCapacity = (int)Math.round((double)this.size() * 1.7) + 7;
        this.nextIndex = 0;
        ++this.modificationNumber;
        if (this.size() * 13 > this.capacity * 9) {
            Edge[] newEdges = new Edge[newCapacity];
            Edge[] newPreviousEdgeWithSameFrom = new Edge[newCapacity];
            Edge[] newPreviousEdgeWithSameTo = new Edge[newCapacity];
            Edge[] newNextEdgeWithSameFrom = new Edge[newCapacity];
            Edge[] newNextEdgeWithSameTo = new Edge[newCapacity];
            for (int i = 0; i < this.capacity; ++i) {
                if (this.edges[i] == null) continue;
                newEdges[this.nextIndex] = this.edges[i];
                newPreviousEdgeWithSameFrom[this.nextIndex] = this.previousEdgeWithSameFrom[i];
                newPreviousEdgeWithSameTo[this.nextIndex] = this.previousEdgeWithSameTo[i];
                newNextEdgeWithSameFrom[this.nextIndex] = this.nextEdgeWithSameFrom[i];
                newNextEdgeWithSameTo[this.nextIndex] = this.nextEdgeWithSameTo[i];
                this.edgeIndices.remove(this.edges[i].key());
                this.edgeIndices.put(this.edges[i].key(), this.nextIndex);
                ++this.nextIndex;
            }
            this.capacity = newCapacity;
            this.edges = newEdges;
            this.previousEdgeWithSameFrom = newPreviousEdgeWithSameFrom;
            this.previousEdgeWithSameTo = newPreviousEdgeWithSameTo;
            this.nextEdgeWithSameFrom = newNextEdgeWithSameFrom;
            this.nextEdgeWithSameTo = newNextEdgeWithSameTo;
        } else {
            this.tighten();
        }
    }

    private void tighten() {
        this.nextIndex = 0;
        for (int i = 0; i < this.capacity; ++i) {
            if (this.edges[i] == null) continue;
            if (i > this.nextIndex) {
                this.edges[this.nextIndex] = this.edges[i];
                this.previousEdgeWithSameFrom[this.nextIndex] = this.previousEdgeWithSameFrom[i];
                this.previousEdgeWithSameTo[this.nextIndex] = this.previousEdgeWithSameTo[i];
                this.nextEdgeWithSameFrom[this.nextIndex] = this.nextEdgeWithSameFrom[i];
                this.nextEdgeWithSameTo[this.nextIndex] = this.nextEdgeWithSameTo[i];
                this.edgeIndices.remove(this.edges[i].key());
                this.edgeIndices.put(this.edges[i].key(), this.nextIndex);
                this.edges[i] = null;
                this.previousEdgeWithSameFrom[i] = null;
                this.previousEdgeWithSameTo[i] = null;
                this.nextEdgeWithSameFrom[i] = null;
                this.nextEdgeWithSameTo[i] = null;
            }
            ++this.nextIndex;
        }
    }

    @Override
    public GraphIterator<Edge> iterator() {
        return new EdgeSetIterator();
    }

    @Override
    public long getModificationNumber() {
        return this.modificationNumber;
    }

    @Override
    public Edge getKeyedObject(long key) {
        if (this.edgeIndices.contains(key)) {
            try {
                return this.edges[this.edgeIndices.get(key)];
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public Set<Edge> toSet() {
        GraphIterator<Edge> i = this.iterator();
        HashSet<Edge> s = new HashSet<Edge>(this.size());
        while (i.hasNext()) {
            s.add(i.next());
        }
        return s;
    }

    public Edge[] toArray() {
        Edge[] theEdges = new Edge[this.size()];
        int i = 0;
        int cnt = 0;
        int done = this.size();
        while (cnt < done) {
            if (this.edges[i] != null) {
                theEdges[cnt++] = this.edges[i];
            }
            ++i;
        }
        return theEdges;
    }

    private class EdgeSetIterator
    implements GraphIterator<Edge> {
        private int currentPosition = -1;
        private int nextPosition = -1;
        private long edgeSetModificationNumber;

        public EdgeSetIterator() {
            this.edgeSetModificationNumber = EdgeSet.this.getModificationNumber();
            this.getNextPosition();
        }

        private void getNextPosition() {
            ++this.nextPosition;
            while (this.nextPosition < EdgeSet.this.capacity() && EdgeSet.this.edges[this.nextPosition] == null) {
                ++this.nextPosition;
            }
        }

        @Override
        public boolean hasNext() throws ConcurrentModificationException {
            if (this.edgeSetModificationNumber != EdgeSet.this.getModificationNumber()) {
                throw new ConcurrentModificationException("Edge Set Modified");
            }
            return this.nextPosition < EdgeSet.this.capacity();
        }

        @Override
        public Edge next() throws ConcurrentModificationException {
            if (this.edgeSetModificationNumber != EdgeSet.this.getModificationNumber()) {
                throw new ConcurrentModificationException("Edge Set Modified");
            }
            if (this.nextPosition < EdgeSet.this.capacity()) {
                this.currentPosition = this.nextPosition;
                this.getNextPosition();
                return EdgeSet.this.edges[this.currentPosition];
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean remove() throws ConcurrentModificationException {
            if (this.edgeSetModificationNumber != EdgeSet.this.getModificationNumber()) {
                throw new ConcurrentModificationException("Edge Set Modified");
            }
            boolean removed = EdgeSet.this.remove(EdgeSet.this.edges[this.currentPosition]);
            this.edgeSetModificationNumber = EdgeSet.this.getModificationNumber();
            return removed;
        }
    }
}

