/*
 * Decompiled with CFR 0.152.
 */
package resources;

import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.TranslateIcon;

public class MultiIconBuilder {
    private MultiIcon multiIcon;
    private String description;

    public MultiIconBuilder(Icon baseIcon) {
        this.multiIcon = new MultiIcon(Objects.requireNonNull(baseIcon));
    }

    public MultiIconBuilder addLowerRightIcon(Icon icon) {
        return this.addLowerRightIcon(icon, icon.getIconWidth(), icon.getIconHeight());
    }

    public MultiIconBuilder addLowerRightIcon(Icon icon, int w, int h) {
        ImageIcon scaled = ResourceManager.getScaledIcon(icon, w, h);
        int x = this.multiIcon.getIconWidth() - scaled.getIconWidth();
        int y = this.multiIcon.getIconHeight() - scaled.getIconHeight();
        TranslateIcon txIcon = new TranslateIcon(scaled, x, y);
        this.multiIcon.addIcon(txIcon);
        return this;
    }

    public MultiIconBuilder addLowerLeftIcon(Icon icon) {
        return this.addLowerLeftIcon(icon, icon.getIconWidth(), icon.getIconHeight());
    }

    public MultiIconBuilder addLowerLeftIcon(Icon icon, int w, int h) {
        ImageIcon scaled = ResourceManager.getScaledIcon(icon, w, h);
        int x = 0;
        int y = this.multiIcon.getIconHeight() - scaled.getIconHeight();
        TranslateIcon txIcon = new TranslateIcon(scaled, x, y);
        this.multiIcon.addIcon(txIcon);
        return this;
    }

    public MultiIconBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public ImageIcon build() {
        ImageIcon imageIcon = ResourceManager.getImageIcon(this.multiIcon);
        imageIcon.setDescription(this.getDescription());
        return imageIcon;
    }

    private String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return this.multiIcon.toString();
    }
}

