/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import db.DBChangeSet;
import db.DBConstants;
import db.DBHandle;
import db.util.ErrorHandler;
import ghidra.framework.data.AbstractTransactionManager;
import ghidra.framework.data.ContentHandler;
import ghidra.framework.data.DomainObjectAdapter;
import ghidra.framework.data.DomainObjectDBChangeSet;
import ghidra.framework.data.DomainObjectTransactionManager;
import ghidra.framework.data.GhidraFile;
import ghidra.framework.data.LockingTaskMonitor;
import ghidra.framework.data.MetadataManager;
import ghidra.framework.data.OptionsDB;
import ghidra.framework.data.SynchronizedTransactionManager;
import ghidra.framework.model.AbortedTransactionListener;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectLockedException;
import ghidra.framework.model.Transaction;
import ghidra.framework.model.TransactionListener;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.options.AbstractOptions;
import ghidra.framework.options.Options;
import ghidra.framework.options.SubOptions;
import ghidra.framework.store.LockException;
import ghidra.framework.store.db.PackedDatabase;
import ghidra.util.Msg;
import ghidra.util.ReadOnlyException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class DomainObjectAdapterDB
extends DomainObjectAdapter
implements UndoableDomainObject,
ErrorHandler,
DBConstants {
    protected static final int NUM_UNDOS = 50;
    protected DBHandle dbh;
    protected DomainObjectDBChangeSet changeSet;
    protected OptionsDB options;
    volatile boolean closed = false;
    private volatile boolean fatalErrorOccurred = false;
    private AbstractTransactionManager transactionMgr;

    protected DomainObjectAdapterDB(DBHandle dbh, String name, int timeInterval, int bufSize, Object consumer) {
        super(name, timeInterval, bufSize, consumer);
        this.dbh = dbh;
        this.options = new OptionsDB(this);
        this.transactionMgr = new DomainObjectTransactionManager(this);
    }

    void setTransactionManager(AbstractTransactionManager transactionMgr) {
        this.transactionMgr = transactionMgr;
    }

    AbstractTransactionManager getTransactionManager() {
        return this.transactionMgr;
    }

    public void flushWriteCache() {
    }

    public void invalidateWriteCache() {
    }

    @Override
    public DomainObject[] getSynchronizedDomainObjects() {
        if (this.transactionMgr instanceof SynchronizedTransactionManager) {
            return this.transactionMgr.getDomainObjects();
        }
        return null;
    }

    @Override
    public void addSynchronizedDomainObject(DomainObject domainObj) throws LockException {
        if (!(domainObj instanceof DomainObjectAdapterDB)) {
            Msg.debug((Object)this, (Object)("Attempted to synchronize to a domainObject that is not a domainObjectDB: " + domainObj.getClass()));
            return;
        }
        DomainObjectAdapterDB other = (DomainObjectAdapterDB)domainObj;
        if (this.transactionMgr instanceof SynchronizedTransactionManager) {
            if (!(other.transactionMgr instanceof DomainObjectTransactionManager)) {
                throw new IllegalStateException();
            }
            SynchronizedTransactionManager manager = (SynchronizedTransactionManager)this.transactionMgr;
            manager.addDomainObject(other);
        } else if (other.transactionMgr instanceof SynchronizedTransactionManager) {
            if (!(this.transactionMgr instanceof DomainObjectTransactionManager)) {
                throw new IllegalStateException();
            }
            SynchronizedTransactionManager manager = (SynchronizedTransactionManager)other.transactionMgr;
            manager.addDomainObject(this);
        } else {
            SynchronizedTransactionManager manager = new SynchronizedTransactionManager();
            manager.addDomainObject(this);
            manager.addDomainObject(other);
        }
    }

    @Override
    public void releaseSynchronizedDomainObject() throws LockException {
        if (!(this.transactionMgr instanceof SynchronizedTransactionManager)) {
            return;
        }
        ((SynchronizedTransactionManager)this.transactionMgr).removeDomainObject(this);
    }

    public DBHandle getDBHandle() {
        return this.dbh;
    }

    protected DomainObjectAdapterDB getUserData() {
        return null;
    }

    public DomainObjectDBChangeSet getChangeSet() {
        return this.changeSet;
    }

    public void dbError(IOException e) {
        this.fatalErrorOccurred = true;
        this.fatalErrorOccurred(e);
    }

    @Override
    public List<String> getOptionsNames() {
        List childOptions = this.options.getChildOptions();
        ArrayList<String> names = new ArrayList<String>(childOptions.size());
        for (Options options : childOptions) {
            names.add(options.getName());
        }
        return names;
    }

    @Override
    public Options getOptions(String propertyListName) {
        return new SubOptions((AbstractOptions)this.options, propertyListName, propertyListName + ".");
    }

    protected void performPropertyListAlterations(Map<String, String> propertyAlterations, TaskMonitor monitor) throws IOException {
        monitor.setProgress(0L);
        monitor.setMessage("Fixing Properties...");
        this.options.performAlterations(propertyAlterations);
    }

    @Override
    public boolean canLock() {
        return this.transactionMgr.getCurrentTransaction() == null && !this.closed;
    }

    @Override
    public boolean isLocked() {
        return this.transactionMgr.isLocked();
    }

    @Override
    public boolean lock(String reason) {
        return this.transactionMgr.lock(reason);
    }

    void prepareToSave() {
        int txId = this.transactionMgr.startTransaction(this, "Update Metadata", null, true, true);
        try {
            this.updateMetadata();
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.transactionMgr.endTransaction(this, txId, true, true);
        }
    }

    LockingTaskMonitor lockForSnapshot(boolean hasProgress, String title) {
        return this.transactionMgr.lockForSnapshot(this, hasProgress, title);
    }

    @Override
    public void forceLock(boolean rollback, String reason) {
        this.transactionMgr.forceLock(rollback, reason);
    }

    @Override
    public void unlock() {
        this.transactionMgr.unlock();
    }

    void unlock(LockingTaskMonitor handler) {
        this.transactionMgr.unlock(handler);
    }

    @Override
    public int startTransaction(String description) {
        return this.startTransaction(description, null);
    }

    @Override
    public int startTransaction(String description, AbortedTransactionListener listener) {
        int id = -1;
        while (id == -1) {
            try {
                id = this.transactionMgr.startTransaction(this, description, listener, true);
            }
            catch (DomainObjectLockedException e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    Msg.debug((Object)this, (Object)"Unexpected thread interrupt", (Throwable)e1);
                }
            }
        }
        return id;
    }

    @Override
    public void endTransaction(int transactionID, boolean commit) {
        this.transactionMgr.endTransaction(this, transactionID, commit, true);
    }

    @Override
    public void addTransactionListener(TransactionListener listener) {
        this.transactionMgr.addTransactionListener(this, listener);
    }

    @Override
    public void removeTransactionListener(TransactionListener listener) {
        this.transactionMgr.removeTransactionListener(this, listener);
    }

    public int getUndoStackDepth() {
        return this.transactionMgr.getUndoStackDepth();
    }

    @Override
    public boolean canRedo() {
        return this.transactionMgr.canRedo();
    }

    @Override
    public boolean canUndo() {
        return this.transactionMgr.canUndo();
    }

    @Override
    public String getRedoName() {
        return this.transactionMgr.getRedoName();
    }

    @Override
    public String getUndoName() {
        return this.transactionMgr.getUndoName();
    }

    @Override
    public Transaction getCurrentTransaction() {
        return this.transactionMgr.getCurrentTransaction();
    }

    @Override
    public void redo() throws IOException {
        this.transactionMgr.redo();
    }

    @Override
    public void undo() throws IOException {
        this.transactionMgr.undo();
    }

    @Override
    public boolean isChanged() {
        if (this.dbh == null) {
            return false;
        }
        return super.isChanged() && this.dbh.isChanged();
    }

    @Override
    protected void setChanged(boolean b) {
        super.setChanged(b);
        if (!b) {
            this.clearUndo(true);
        }
    }

    protected boolean propertyChanged(String propertyName, Object oldValue, Object newValue) {
        this.setChanged(true);
        this.fireEvent(new DomainObjectChangeRecord(5, this.name, this.name));
        return true;
    }

    @Override
    public void clearUndo() {
        this.clearUndo(true);
    }

    protected void clearUndo(boolean notifyListeners) {
        this.transactionMgr.clearUndo(notifyListeners);
    }

    protected void clearCache(boolean all) {
        this.options.clearCache();
    }

    @Override
    public synchronized boolean canSave() {
        DomainFile df = this.getDomainFile();
        if (df instanceof GhidraFile) {
            return df.isInWritableProject() && this.dbh.canUpdate() && !df.isReadOnly();
        }
        return this.dbh.canUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(String comment, TaskMonitor monitor) throws IOException, CancelledException {
        if (!this.canSave()) {
            throw new ReadOnlyException("File is read-only");
        }
        boolean wasSaved = false;
        if (!this.lock("save")) {
            throw new IOException("Unable to lock due to active transaction");
        }
        try {
            DomainObjectAdapterDB domainObjectAdapterDB = this;
            synchronized (domainObjectAdapterDB) {
                if (this.changed) {
                    this.dbh.save(comment, (DBChangeSet)this.getChangeSet(), monitor);
                    this.setChanged(false);
                    wasSaved = true;
                }
            }
            DomainObjectAdapterDB userData = this.getUserData();
            if (userData != null && userData.isChanged()) {
                userData.save(comment, monitor);
            }
        }
        finally {
            this.unlock();
        }
        if (wasSaved) {
            this.fireEvent(new DomainObjectChangeRecord(1));
            DomainFile df = this.getDomainFile();
            if (df instanceof GhidraFile) {
                ((GhidraFile)df).fileChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveToPackedFile(File outputFile, TaskMonitor monitor) throws IOException, CancelledException {
        this.transactionMgr.checkLockingTask();
        if (!this.lock("saveToPackedFile")) {
            throw new IOException("Unable to lock due to active transaction");
        }
        try {
            ContentHandler ch = DomainObjectAdapter.getContentHandler(this);
            PackedDatabase.packDatabase((DBHandle)this.dbh, (String)this.name, (String)ch.getContentType(), (File)outputFile, (TaskMonitor)monitor);
        }
        finally {
            this.unlock();
        }
    }

    protected void updateMetadata() throws IOException {
        this.saveMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() {
        AbstractTransactionManager abstractTransactionManager = this.transactionMgr;
        synchronized (abstractTransactionManager) {
            this.transactionMgr.close(this);
            this.closed = true;
        }
        DomainObjectAdapterDB userData = this.getUserData();
        if (userData != null && userData.isChanged() && this.getDomainFile() instanceof GhidraFile) {
            try {
                userData.save(null, TaskMonitorAdapter.DUMMY_MONITOR);
            }
            catch (CancelledException cancelledException) {
            }
            catch (IOException e) {
                Msg.warn((Object)this, (Object)("Failed to save user data for: " + this.getDomainFile().getName()));
            }
        }
        super.close();
        this.dbh.close(this.fatalErrorOccurred);
        if (userData != null) {
            userData.close();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean hasTerminatedTransaction() {
        return this.transactionMgr.hasTerminatedTransaction();
    }

    protected void loadMetadata() throws IOException {
        MetadataManager.loadData(this, this.metadata);
    }

    protected void saveMetadata() throws IOException {
        MetadataManager.saveData(this, this.metadata);
    }
}

