/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.MenuData;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.datatable.DomainFileProvider;
import ghidra.framework.main.datatree.UndoActionDialog;
import ghidra.framework.main.projectdata.actions.VersionControlAction;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.plugintool.Plugin;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class VersionControlUndoHijackAction
extends VersionControlAction {
    public VersionControlUndoHijackAction(Plugin plugin) {
        super("Undo Hijack", plugin.getName(), plugin.getTool());
        ImageIcon icon = ResourceManager.loadImage((String)"images/undo_hijack.png");
        this.setPopupMenuData(new MenuData(new String[]{"Undo Hijack"}, (Icon)icon, "Repository"));
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(DomainFileProvider context) {
        this.undoHijackedFiles(context.getSelectedFiles());
    }

    @Override
    public boolean isEnabledForContext(DomainFileProvider context) {
        List<DomainFile> domainFiles = context.getSelectedFiles();
        for (DomainFile domainFile : domainFiles) {
            if (!domainFile.isHijacked()) continue;
            return true;
        }
        return false;
    }

    private void undoHijackedFiles(List<DomainFile> domainFiles) {
        if (!this.checkRepositoryConnected()) {
            return;
        }
        ArrayList<DomainFile> hijackList = new ArrayList<DomainFile>();
        for (DomainFile domainFile : domainFiles) {
            if (domainFile == null || !domainFile.isHijacked()) continue;
            hijackList.add(domainFile);
        }
        this.undoHijack(hijackList);
    }

    void undoHijack(List<DomainFile> hijackList) {
        UndoActionDialog dialog;
        int actionID;
        if (!this.checkRepositoryConnected()) {
            return;
        }
        if (hijackList.size() > 0 && (actionID = (dialog = new UndoActionDialog("Confirm Undo Hijack", ResourceManager.loadImage((String)"images/undo_hijack.png"), "Undo_Hijack", "hijack", hijackList)).showDialog(this.tool)) != 1) {
            boolean saveCopy = dialog.saveCopy();
            DomainFile[] files = dialog.getSelectedDomainFiles();
            if (files.length > 0) {
                this.tool.execute(new UndoHijackTask(files, saveCopy));
            }
        }
    }

    private String getKeepName(DomainFolder parent, String name) {
        int oneUp = 1;
        String keepName = name + ".keep";
        DomainFile df = parent.getFile(keepName);
        if (df != null) {
            keepName = name + ".keep" + oneUp;
            ++oneUp;
        }
        return keepName;
    }

    private class UndoHijackTask
    extends Task {
        private DomainFile[] hijackFiles;
        private boolean saveCopy;

        UndoHijackTask(DomainFile[] hijackFiles, boolean saveCopy) {
            super("Undo Hijack", true, true, true);
            this.hijackFiles = hijackFiles;
            this.saveCopy = saveCopy;
        }

        public void run(TaskMonitor monitor) {
            try {
                for (DomainFile currentDF : this.hijackFiles) {
                    monitor.checkCanceled();
                    monitor.setMessage("Undoing Hijack " + currentDF.getName());
                    if (this.saveCopy) {
                        try {
                            currentDF.setName(VersionControlUndoHijackAction.this.getKeepName(currentDF.getParent(), currentDF.getName()));
                        }
                        catch (InvalidNameException invalidNameException) {}
                        continue;
                    }
                    currentDF.delete();
                }
            }
            catch (CancelledException e) {
                VersionControlUndoHijackAction.this.tool.setStatusInfo("Undo hijack was canceled");
            }
            catch (IOException e) {
                ClientUtil.handleException((RepositoryAdapter)VersionControlUndoHijackAction.this.repository, (Exception)e, (String)"Undo Hijack", (Component)VersionControlUndoHijackAction.this.tool.getToolFrame());
            }
        }
    }
}

