/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.bplist;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.bplist.BinaryPropertyListHeader;
import ghidra.file.formats.bplist.BinaryPropertyListTrailer;
import ghidra.file.formats.bplist.BinaryPropertyListUtil;
import ghidra.file.formats.bplist.ImmutableMemoryRangeByteProvider;
import ghidra.file.formats.bplist.NSObject;
import ghidra.file.formats.bplist.NSObjectParser;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;

public class BinaryPropertyListAnalyzer
extends FileFormatAnalyzer {
    public String getName() {
        return "Binary Property List (BPLIST) Annotation";
    }

    public boolean getDefaultEnablement(Program program) {
        return false;
    }

    public String getDescription() {
        return "Annotates a Binary Property List (BPLIST).";
    }

    public boolean canAnalyze(Program program) {
        MemoryBlock[] blocks;
        Memory memory = program.getMemory();
        for (MemoryBlock block : blocks = memory.getBlocks()) {
            if (!BinaryPropertyListUtil.isBinaryPropertyList(memory, block.getStart())) continue;
            return true;
        }
        return false;
    }

    public boolean isPrototype() {
        return false;
    }

    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        Memory memory = program.getMemory();
        for (MemoryBlock block : memory.getBlocks()) {
            monitor.checkCanceled();
            if (!BinaryPropertyListUtil.isBinaryPropertyList(memory, block.getStart())) continue;
            ImmutableMemoryRangeByteProvider provider = new ImmutableMemoryRangeByteProvider(memory, block.getStart(), block.getEnd());
            this.markup(block.getStart(), provider, program, monitor);
        }
        this.removeEmptyFragments(program);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markup(Address baseAddress, ByteProvider provider, Program program, TaskMonitor monitor) throws Exception {
        BinaryReader reader = new BinaryReader(provider, false);
        try {
            BinaryPropertyListHeader header = this.markupBinaryPropertyListHeader(program, reader, baseAddress);
            BinaryPropertyListTrailer trailer = this.markupBinaryPropertyListTrailer(program, header, baseAddress);
            this.markupObjects(reader, program, trailer, baseAddress, monitor);
            this.markupOffsetTable(program, trailer, baseAddress, monitor);
        }
        finally {
            provider.close();
        }
    }

    private void markupOffsetTable(Program program, BinaryPropertyListTrailer trailer, Address baseAddress, TaskMonitor monitor) throws Exception {
        ByteDataType offsetDataType = null;
        if (trailer.getOffsetSize() == 1) {
            offsetDataType = new ByteDataType();
        } else if (trailer.getOffsetSize() == 2) {
            offsetDataType = new WordDataType();
        } else if (trailer.getOffsetSize() == 4) {
            offsetDataType = new DWordDataType();
        } else if (trailer.getOffsetSize() == 8) {
            offsetDataType = new QWordDataType();
        } else {
            throw new RuntimeException("unexpected offset table element size");
        }
        Address offsetTableAddress = baseAddress.add((long)trailer.getOffsetTableOffset());
        Address end = offsetTableAddress.add((long)(trailer.getObjectCount() * offsetDataType.getLength()));
        ArrayDataType datatype = new ArrayDataType((DataType)offsetDataType, trailer.getObjectCount(), offsetDataType.getLength());
        this.clearListing(program, offsetTableAddress, end);
        this.createData(program, offsetTableAddress, (DataType)datatype);
        this.setPlateComment(program, offsetTableAddress, "OFFSET_TABLE");
        this.createFragment(program, "OFFSET_TABLE", offsetTableAddress, end);
    }

    private void markupObjects(BinaryReader reader, Program program, BinaryPropertyListTrailer trailer, Address baseAddress, TaskMonitor monitor) throws Exception {
        HashMap<NSObject, Data> objectMap = new HashMap<NSObject, Data>();
        for (int i = 0; i < trailer.getOffsetTable().length; ++i) {
            monitor.checkCanceled();
            int objectOffset = trailer.getOffsetTable()[i];
            NSObject object = NSObjectParser.parseObject(reader, objectOffset, trailer);
            Address objectAddress = baseAddress.add((long)objectOffset);
            String name = BinaryPropertyListUtil.generateName(i);
            this.setPlateComment(program, objectAddress, name + "\n" + object.toString());
            program.getSymbolTable().createLabel(objectAddress, name, SourceType.ANALYSIS);
            DataType objectDataType = object.toDataType();
            this.createFragment(program, object.getType(), objectAddress, objectAddress.add((long)objectDataType.getLength()));
            this.clearListing(program, objectAddress, objectAddress.add((long)objectDataType.getLength()));
            Data objectData = this.createData(program, objectAddress, objectDataType);
            objectMap.put(object, objectData);
        }
        for (NSObject object : objectMap.keySet()) {
            monitor.checkCanceled();
            object.markup((Data)objectMap.get(object), program, monitor);
        }
        for (NSObject object : objectMap.keySet()) {
            monitor.checkCanceled();
            this.handleNestedBinaryPlist(object, program, (Data)objectMap.get(object), monitor);
        }
    }

    private BinaryPropertyListTrailer markupBinaryPropertyListTrailer(Program program, BinaryPropertyListHeader header, Address baseAddress) throws Exception {
        BinaryPropertyListTrailer trailer = header.getTrailer();
        Address trailerAddress = baseAddress.add(trailer.getTrailerIndex());
        DataType trailerDataType = trailer.toDataType();
        this.clearListing(program, trailerAddress, trailerAddress.add((long)trailerDataType.getLength()));
        this.createData(program, trailerAddress, trailerDataType);
        this.createFragment(program, trailerDataType.getName(), trailerAddress, trailerAddress.add((long)trailerDataType.getLength()));
        this.setPlateComment(program, trailerAddress, "Binary Property List Trailer");
        return trailer;
    }

    private BinaryPropertyListHeader markupBinaryPropertyListHeader(Program program, BinaryReader reader, Address baseAddress) throws Exception {
        BinaryPropertyListHeader header = new BinaryPropertyListHeader(reader);
        Address headerAddress = baseAddress.add(0L);
        DataType headerDataType = header.toDataType();
        this.clearListing(program, headerAddress, headerAddress.add((long)headerDataType.getLength()));
        this.createData(program, headerAddress, headerDataType);
        this.createFragment(program, headerDataType.getName(), headerAddress, headerAddress.add((long)headerDataType.getLength()));
        this.setPlateComment(program, headerAddress, "Binary Property List Header");
        return header;
    }

    private void handleNestedBinaryPlist(NSObject object, Program program, Data objectData, TaskMonitor monitor) throws Exception {
    }

    private void clearListing(Program program, Address startAddress, Address endAddress) {
        program.getListing().clearCodeUnits(startAddress, endAddress.subtract(1L), true);
    }
}

