/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.img3;

import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.ios.img3.AbstractImg3Tag;
import ghidra.file.formats.ios.img3.Img3;
import ghidra.file.formats.ios.img3.Img3Util;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class Img3Analyzer
extends FileFormatAnalyzer
implements AnalysisWorker {
    public boolean canAnalyze(Program program) {
        return Img3Util.isIMG3(program);
    }

    public boolean getDefaultEnablement(Program program) {
        return Img3Util.isIMG3(program);
    }

    public String getDescription() {
        return "Annotates an IMG3 file.";
    }

    public String getName() {
        return "IMG3 Annotation";
    }

    public boolean isPrototype() {
        return true;
    }

    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager((Program)program);
        return manager.scheduleWorker((AnalysisWorker)this, null, false, monitor);
    }

    public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor monitor) throws Exception, CancelledException {
        Address address = program.getMinAddress();
        MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), address);
        BinaryReader reader = new BinaryReader((ByteProvider)provider, true);
        Img3 header = new Img3(reader);
        if (!header.getMagic().equals("Img3")) {
            return false;
        }
        DataType headerDataType = header.toDataType();
        Data headerData = this.createData(program, address, headerDataType);
        this.createFragment(program, headerDataType.getName(), headerData.getMinAddress(), headerData.getMaxAddress().add(1L));
        Address tagAddress = headerData.getMaxAddress().add(1L);
        this.applyTags(program, header, tagAddress, monitor);
        this.changeDataSettings(program, monitor);
        this.removeEmptyFragments(program);
        return true;
    }

    public String getWorkerName() {
        return this.getName();
    }

    private void applyTags(Program program, Img3 header, Address tagAddress, TaskMonitor monitor) throws Exception {
        List<AbstractImg3Tag> tags = header.getTags();
        for (AbstractImg3Tag tag : tags) {
            if (monitor.isCancelled()) break;
            DataType dt = tag.toDataType();
            this.setPlateComment(program, tagAddress, tag.getMagic());
            this.createData(program, tagAddress, dt);
            this.createFragment(program, tag.getMagic(), tagAddress, tagAddress.add((long)tag.getTotalLength()));
            tagAddress = tagAddress.add((long)tag.getTotalLength());
        }
    }
}

