/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.jad;

import ghidra.app.util.importer.MessageLog;
import ghidra.file.jad.JadProcessWrapper;
import ghidra.util.Msg;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.TaskMonitor;
import ghidra.util.timer.GTimer;
import ghidra.util.timer.GTimerMonitor;
import java.io.IOException;
import java.io.InputStream;

public class JadProcessController {
    private CancelledListener listener = new CancelledListener(){

        public void cancelled() {
            JadProcessController.this.dispose();
            JadProcessController.this.disposeState = DisposeState.DISPOSED_ON_CANCEL;
        }
    };
    private MessageLog log = new MessageLog();
    private Runtime runtime = Runtime.getRuntime();
    private String[] environment = new String[0];
    private Runnable timeoutRunnable;
    private volatile DisposeState disposeState = DisposeState.NOT_DISPOSED;
    private volatile Process process;
    private volatile InputStream stdin;
    private volatile InputStream stderr;
    private String desc;
    private JadProcessWrapper wrapper;

    public JadProcessController(JadProcessWrapper wrapper, String desc) {
        this.wrapper = wrapper;
        this.desc = desc;
        this.timeoutRunnable = new Runnable(){

            @Override
            public void run() {
                if (JadProcessController.this.disposeState == DisposeState.ENDED_HAPPY) {
                    return;
                }
                JadProcessController.this.dispose();
                JadProcessController.this.disposeState = DisposeState.DISPOSED_ON_TIMEOUT;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decompile(int timeoutSecs, TaskMonitor monitor) throws IOException {
        monitor.addCancelledListener(this.listener);
        GTimerMonitor timerMonitor = GTimer.scheduleRunnable((long)(timeoutSecs * 1000), (Runnable)this.timeoutRunnable);
        try {
            String[] commands = this.wrapper.getCommands();
            this.process = this.runtime.exec(commands, this.environment, this.wrapper.getWorkingDirectory());
            if (this.process == null) {
                System.out.println("native process is null");
                return;
            }
            this.stdin = this.process.getInputStream();
            this.stderr = this.process.getErrorStream();
            this.readMessagesFromProcess(this.stdin, "JAD STDOUT " + this.desc, monitor);
            this.readMessagesFromProcess(this.stderr, "JAD STDERR " + this.desc, monitor);
            this.waitForProcess();
            this.disposeState = DisposeState.ENDED_HAPPY;
        }
        finally {
            timerMonitor.cancel();
        }
    }

    private void waitForProcess() {
        try {
            this.process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void readMessagesFromProcess(final InputStream inputStream, final String streamName, final TaskMonitor monitor) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StringBuffer buffer = new StringBuffer();
                try {
                    int nRead;
                    byte[] bytes = new byte[4096];
                    while (!monitor.isCancelled() && (nRead = inputStream.read(bytes)) != -1) {
                        buffer.append(new String(bytes, 0, nRead));
                    }
                }
                catch (Exception e) {
                    Msg.error((Object)this, (Object)"Exception while reading JAD process inputstream", (Throwable)e);
                }
                String string = buffer.toString().trim();
                if (string.length() > 0) {
                    string = string.replace("\n", "\n" + streamName + ": ");
                    Msg.info((Object)JadProcessController.this, (Object)("\n" + streamName + ": " + string));
                }
            }
        };
        Thread thread = new Thread(runnable, "JAD processes stdout/stderr reader");
        thread.start();
    }

    public void dispose() {
        if (this.disposeState != DisposeState.NOT_DISPOSED) {
            return;
        }
        this.disposeState = DisposeState.DISPOSED_ON_CANCEL;
        new Thread(new Disposer()).start();
    }

    public MessageLog getMessages() {
        return this.log;
    }

    private class Disposer
    implements Runnable {
        private Disposer() {
        }

        @Override
        public void run() {
            InputStream stdinCopy = JadProcessController.this.stdin;
            InputStream stderrCopy = JadProcessController.this.stderr;
            JadProcessController.this.stdin = null;
            JadProcessController.this.stderr = null;
            this.closeProcess();
            this.close(stdinCopy);
            this.close(stderrCopy);
        }

        private void closeProcess() {
            try {
                if (JadProcessController.this.process != null) {
                    JadProcessController.this.process.destroy();
                    JadProcessController.this.process = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void close(InputStream inputStream) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static enum DisposeState {
        NOT_DISPOSED,
        DISPOSED_ON_TIMEOUT,
        DISPOSED_ON_CANCEL,
        ENDED_HAPPY;

    }
}

