/*
 * Decompiled with CFR 0.152.
 */
package docking.dnd;

import docking.dnd.Draggable;
import ghidra.util.Msg;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.InputEvent;

public class DragGestureAdapter
implements DragGestureListener {
    private Draggable dragComponent;

    public DragGestureAdapter(Draggable dragComponent) {
        this.dragComponent = dragComponent;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        InputEvent ie = e.getTriggerEvent();
        int modifiers = ie.getModifiers();
        if ((modifiers & 8) != 0 || (modifiers & 4) != 0) {
            return;
        }
        int dragAction = this.dragComponent.getDragAction();
        if ((e.getDragAction() & dragAction) == 0 || !this.dragComponent.isStartDragOk(e)) {
            return;
        }
        Transferable t = this.dragComponent.getTransferable(e.getDragOrigin());
        DragSourceListener l = this.dragComponent.getDragSourceListener();
        if (t == null || l == null) {
            return;
        }
        try {
            e.startDrag(DragSource.DefaultCopyNoDrop, t, l);
        }
        catch (InvalidDnDOperationException exc) {
            Msg.error((Object)this, (Object)("Exception occurred during drag initiation: " + exc), (Throwable)exc);
        }
    }
}

