/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.ColumnSortState;
import docking.widgets.table.GTableHeader;
import docking.widgets.table.RowObjectFilterModel;
import docking.widgets.table.SortedTableModel;
import docking.widgets.table.TableFilter;
import docking.widgets.table.TableSortState;
import docking.widgets.table.VariableColumnTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import resources.Icons;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.EmptyIcon;
import resources.icons.TranslateIcon;

public class GTableHeaderRenderer
extends JPanel
implements TableCellRenderer {
    private static final int PADDING_FOR_COLUMN_NUMBER = 10;
    private static final Color PRIMARY_SORT_GRADIENT_START = new Color(205, 227, 244);
    private static final Color PRIMARY_SORT_GRADIENT_END = new Color(126, 186, 233);
    private static final Color DEFAULT_GRADIENT_START = Color.WHITE;
    private static final Color DEFAULT_GRADIENT_END = new Color(215, 215, 215);
    private static final Icon UP_ICON = ResourceManager.getScaledIcon((Icon)Icons.SORT_ASCENDING_ICON, (int)14, (int)14);
    private static final Icon DOWN_ICON = ResourceManager.getScaledIcon((Icon)Icons.SORT_DESCENDING_ICON, (int)14, (int)14);
    private static final int DEFAULT_MIN_HEIGHT = UP_ICON.getIconHeight();
    private static final Icon FILTER_ICON = ResourceManager.getScaledIcon((Icon)ResourceManager.loadImage((String)"images/filter_off.png"), (int)12, (int)12);
    private JLabel textLabel = new JLabel();
    private JLabel iconLabel = new JLabel();
    private Icon helpIcon = null;
    private CustomPaddingBorder customBorder;
    protected boolean isPaintingPrimarySortColumn;

    public GTableHeaderRenderer() {
        this.textLabel.setHorizontalTextPosition(2);
        this.iconLabel.setHorizontalAlignment(4);
        this.textLabel.setBorder(this.createOSSpecificBorder());
        this.setLayout(new BorderLayout());
        this.add((Component)this.textLabel, "Center");
        this.add((Component)this.iconLabel, "East");
        this.customBorder = new CustomPaddingBorder();
        this.setBorder(this.customBorder);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        this.paintHelpIcon(g);
    }

    private void paintHelpIcon(Graphics g) {
        if (this.helpIcon == null) {
            return;
        }
        Point paintPoint = this.getHelpIconLocation();
        this.helpIcon.paintIcon(this, g, paintPoint.x, paintPoint.y);
    }

    private Point getHelpIconLocation() {
        int primaryWidth = this.iconLabel.getWidth();
        int overlayWidth = this.helpIcon.getIconWidth();
        Point paintPoint = new Point(primaryWidth - overlayWidth, 0);
        return SwingUtilities.convertPoint(this.iconLabel, paintPoint, this);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        Border currentBorder = this.getBorder();
        int minHeight = DEFAULT_MIN_HEIGHT;
        if (currentBorder != null) {
            Insets borderInsets = currentBorder.getBorderInsets(this);
            minHeight += borderInsets.top + borderInsets.bottom;
        }
        preferredSize.height = Math.max(preferredSize.height, minHeight);
        return preferredSize;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.isPaintingPrimarySortColumn = false;
        Icon icon = null;
        String text = value == null ? "" : value.toString();
        JTableHeader header = table.getTableHeader();
        this.setForeground(header.getForeground());
        this.setFont(header.getFont());
        int modelIndex = table.convertColumnIndexToModel(column);
        TableModel model = table.getModel();
        icon = this.getIcon(model, modelIndex);
        VariableColumnTableModel variableModel = VariableColumnTableModel.from(model);
        if (variableModel != null) {
            text = variableModel.getColumnDisplayName(modelIndex);
        }
        this.updateHelpIcon(table, column, icon);
        this.iconLabel.setIcon(icon);
        this.textLabel.setText(text);
        this.setOuterBorder(this.customBorder, column);
        this.setOpaque(false);
        return this;
    }

    private Icon getIcon(TableModel model, int columnModelIndex) {
        Icon icon = null;
        if (model instanceof SortedTableModel) {
            icon = this.getSortIcon(icon, columnModelIndex, model);
        }
        if (this.isColumnFiltered(model, columnModelIndex)) {
            icon = this.combineIcons(icon, FILTER_ICON);
        }
        return icon;
    }

    private Icon combineIcons(Icon icon1, Icon icon2) {
        if (icon1 == null) {
            return icon2;
        }
        if (icon2 == null) {
            return icon1;
        }
        MultiIcon icon = new MultiIcon((Icon)new EmptyIcon(28, 14));
        icon.addIcon(icon2);
        icon.addIcon((Icon)new TranslateIcon(icon1, 14, 0));
        return icon;
    }

    private boolean isColumnFiltered(TableModel model, int columnModelIndex) {
        if (!(model instanceof RowObjectFilterModel)) {
            return false;
        }
        RowObjectFilterModel filterModel = (RowObjectFilterModel)model;
        TableFilter tableFilter = filterModel.getTableFilter();
        if (tableFilter == null) {
            return false;
        }
        return tableFilter.hasColumnFilter(columnModelIndex);
    }

    private void setOuterBorder(CustomPaddingBorder border, int column) {
        if (this.paintAquaHeaders()) {
            if (column == 0) {
                this.customBorder.setOuterBorder(new NoSidesLineBorder(Color.GRAY));
                return;
            }
            this.customBorder.setOuterBorder(new NoRightSideLineBorder(Color.GRAY));
        } else {
            this.customBorder.setOuterBorder(UIManager.getBorder("TableHeader.cellBorder"));
        }
    }

    private boolean paintAquaHeaders() {
        return true;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Paint backgroundColor = this.getBackgroundPaint();
        Paint oldPaint = g2d.getPaint();
        g2d.setPaint(backgroundColor);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setPaint(oldPaint);
        super.paintComponent(g);
    }

    protected Paint getBackgroundPaint() {
        if (this.isPaintingPrimarySortColumn) {
            return new GradientPaint(0.0f, 0.0f, PRIMARY_SORT_GRADIENT_START, 0.0f, this.getHeight() - 11, PRIMARY_SORT_GRADIENT_END, true);
        }
        return new GradientPaint(0.0f, 0.0f, DEFAULT_GRADIENT_START, 0.0f, this.getHeight() - 11, DEFAULT_GRADIENT_END, true);
    }

    private void updateHelpIcon(JTable table, int currentColumnIndex, Icon icon) {
        JTableHeader tableHeader = table.getTableHeader();
        if (!(tableHeader instanceof GTableHeader)) {
            this.helpIcon = null;
            return;
        }
        GTableHeader tooltipTableHeader = (GTableHeader)tableHeader;
        int hoveredColumnIndex = tooltipTableHeader.getHoveredHeaderColumnIndex();
        if (hoveredColumnIndex != currentColumnIndex) {
            this.helpIcon = null;
            return;
        }
        this.helpIcon = tooltipTableHeader.getHelpIcon();
    }

    private Icon getSortIcon(Icon icon, int realIndex, TableModel model) {
        TableSortState pendingTableState;
        ColumnSortState pendingColumnState;
        AbstractSortedTableModel abstractSortedModel;
        SortedTableModel sortedModel = (SortedTableModel)model;
        TableSortState columnSortStates = sortedModel.getTableSortState();
        boolean sortPending = false;
        if (model instanceof AbstractSortedTableModel && (sortPending = (abstractSortedModel = (AbstractSortedTableModel)model).isSortPending()) && (pendingColumnState = (pendingTableState = abstractSortedModel.getPendingSortState()).getColumnSortState(realIndex)) != null) {
            return this.getColumnIconForSortState(columnSortStates, pendingColumnState, true);
        }
        ColumnSortState sortState = columnSortStates.getColumnSortState(realIndex);
        if (sortState == null) {
            return null;
        }
        icon = this.getColumnIconForSortState(columnSortStates, sortState, false);
        if (sortPending) {
            icon = ResourceManager.getDisabledIcon((Icon)icon, (int)65);
        }
        return icon;
    }

    private Icon getColumnIconForSortState(TableSortState columnSortStates, ColumnSortState sortState, boolean isPendingSort) {
        Icon icon;
        Icon icon2 = icon = sortState.isAscending() ? UP_ICON : DOWN_ICON;
        if (columnSortStates.getSortedColumnCount() != 1) {
            MultiIcon multiIcon = new MultiIcon(icon);
            int sortOrder = sortState.getSortOrder();
            if (sortOrder == 1) {
                this.isPaintingPrimarySortColumn = true;
            }
            String numberString = Integer.toString(sortOrder);
            multiIcon.addIcon((Icon)new NumberPainterIcon(icon.getIconWidth() + 10, icon.getIconHeight(), numberString));
            icon = multiIcon;
        } else {
            this.isPaintingPrimarySortColumn = true;
        }
        if (isPendingSort) {
            icon = ResourceManager.loadImage((String)"images/hourglass.png");
        }
        return icon;
    }

    public boolean isSortedAscending() {
        return this.iconLabel.getIcon() == UP_ICON;
    }

    boolean isTextOccluded() {
        return this.textLabel.getPreferredSize().getWidth() > (double)this.textLabel.getWidth();
    }

    private Border createOSSpecificBorder() {
        if (this.paintAquaHeaders()) {
            return new EmptyBorder(1, 2, 1, 2);
        }
        return new EmptyBorder(0, 2, 0, 2);
    }

    private class NumberPainterIcon
    implements Icon {
        private final int iconWidth;
        private final int iconHeight;
        private final String numberText;

        public NumberPainterIcon(int width, int height, String numberText) {
            this.iconWidth = width;
            this.iconHeight = height;
            this.numberText = numberText;
        }

        @Override
        public int getIconHeight() {
            return this.iconHeight;
        }

        @Override
        public int getIconWidth() {
            return this.iconWidth;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int fontSize = 12;
            String fontFamily = "arial";
            Font font = new Font(fontFamily, 1, fontSize);
            g.setFont(font);
            FontMetrics fontMetrics = g.getFontMetrics();
            Rectangle2D stringBounds = fontMetrics.getStringBounds(this.numberText, g);
            int numberWidth = (int)stringBounds.getWidth();
            int numberHeight = fontMetrics.getAscent();
            int insetPadding = 2;
            int startX = x + (this.iconWidth - numberWidth) - insetPadding;
            int textBaseline = numberHeight;
            AttributedString as = new AttributedString(this.numberText);
            as.addAttribute(TextAttribute.FOREGROUND, Color.BLACK);
            as.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            as.addAttribute(TextAttribute.FAMILY, fontFamily);
            as.addAttribute(TextAttribute.SIZE, Float.valueOf(fontSize));
            g.drawString(as.getIterator(), startX, textBaseline);
        }
    }

    private class NoSidesLineBorder
    extends LineBorder {
        NoSidesLineBorder(Color color) {
            super(color);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            super.paintBorder(c, g, x - 1, y, width + 5, height);
        }
    }

    private class NoRightSideLineBorder
    extends LineBorder {
        NoRightSideLineBorder(Color color) {
            super(color);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            super.paintBorder(c, g, x, y, width + 1, height);
        }
    }

    private class CustomPaddingBorder
    extends CompoundBorder {
        private CustomPaddingBorder() {
            this.insideBorder = GTableHeaderRenderer.this.createOSSpecificBorder();
        }

        void setOuterBorder(Border border) {
            this.outsideBorder = border;
        }
    }
}

