/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint;

import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.StringColumnConstraint;
import ghidra.util.UserSearchUtils;
import java.util.regex.Pattern;

public class StringStartsWithColumnConstraint
extends StringColumnConstraint {
    public StringStartsWithColumnConstraint(String patternString) {
        super(patternString);
    }

    @Override
    public String getName() {
        return "Starts With";
    }

    @Override
    public ColumnConstraint<String> copy(String newPatternString) {
        return new StringStartsWithColumnConstraint(newPatternString);
    }

    @Override
    protected Pattern generateMatchesPattern(String patternString) {
        return UserSearchUtils.createStartsWithPattern((String)patternString, (boolean)true, (int)66);
    }
}

