/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.tasks;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeTask;
import docking.widgets.tree.internal.GTreeSelectionModel;
import docking.widgets.tree.support.GTreeSelectionEvent;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public abstract class AbstractSelectPathsTask
extends GTreeTask {
    private final GTreeSelectionEvent.EventOrigin origin;
    private boolean expandingDisabled;

    AbstractSelectPathsTask(GTree gTree, JTree jTree, GTreeSelectionEvent.EventOrigin origin) {
        super(gTree);
        this.origin = origin;
    }

    abstract List<TreePath> getTreePaths();

    void setExpandingDisabled(boolean disabled) {
        this.expandingDisabled = disabled;
    }

    public void run(TaskMonitor monitor) {
        monitor.setMessage("Selecting paths");
        List<TreePath> paths = this.getTreePaths();
        monitor.initialize((long)paths.size());
        ArrayList<TreePath> translatedPaths = new ArrayList<TreePath>();
        for (TreePath path : paths) {
            if (monitor.isCancelled()) {
                return;
            }
            TreePath xPath = this.translatePath(path, monitor);
            if (xPath != null && !this.isFiltered(xPath)) {
                translatedPaths.add(xPath);
            }
            monitor.incrementProgress(1L);
        }
        this.selectPaths(translatedPaths.toArray(new TreePath[translatedPaths.size()]), monitor);
    }

    private boolean isFiltered(TreePath path) {
        GTreeNode node = (GTreeNode)path.getLastPathComponent();
        return node.isFilteredOut();
    }

    private void selectPaths(TreePath[] treePaths, TaskMonitor monitor) {
        this.runOnSwingThread(() -> {
            if (monitor.isCancelled()) {
                return;
            }
            boolean wasEnabled = this.jTree.getExpandsSelectedPaths();
            if (this.expandingDisabled) {
                this.jTree.setExpandsSelectedPaths(false);
            }
            try {
                this.doSelectPaths(treePaths);
            }
            finally {
                if (this.expandingDisabled) {
                    this.jTree.setExpandsSelectedPaths(wasEnabled);
                }
            }
        });
    }

    private void doSelectPaths(TreePath[] treePaths) {
        GTreeSelectionModel selectionModel = this.tree.getGTSelectionModel();
        selectionModel.setSelectionPaths(treePaths, this.origin);
        if (treePaths != null && treePaths.length > 0) {
            this.jTree.scrollPathToVisible(treePaths[treePaths.length - 1]);
        }
    }
}

