/*
 * Decompiled with CFR 0.152.
 */
package ghidra.xml;

import ghidra.xml.XmlElement;
import ghidra.xml.XmlException;
import ghidra.xml.XmlPullParser;

public abstract class AbstractXmlPullParser
implements XmlPullParser {
    @Override
    public XmlElement end() {
        if (!this.hasNext()) {
            throw new XmlException("at EOF but expected end element");
        }
        XmlElement next = this.next();
        if (!next.isEnd()) {
            throw new XmlException("got " + (next.isStart() ? "start" : "content") + "element but expected end element");
        }
        return next;
    }

    @Override
    public XmlElement end(XmlElement element) {
        String name = element.getName();
        if (!this.hasNext()) {
            throw new XmlException("at EOF but expected end element " + name);
        }
        XmlElement next = this.next();
        if (!name.equals(next.getName())) {
            throw new XmlException("got element " + next.getName() + " but expected end element " + name);
        }
        if (!next.isEnd()) {
            throw new XmlException("got " + (next.isStart() ? "start" : "content") + "element but expected end element " + name);
        }
        return next;
    }

    @Override
    public int getColumnNumber() {
        if (this.hasNext()) {
            return this.peek().getColumnNumber();
        }
        return -1;
    }

    @Override
    public int getCurrentLevel() {
        if (this.hasNext()) {
            return this.peek().getLevel();
        }
        return -1;
    }

    @Override
    public int getLineNumber() {
        if (this.hasNext()) {
            return this.peek().getLineNumber();
        }
        return -1;
    }

    private static String collapse(String ... s) {
        StringBuilder sb = new StringBuilder();
        if (s == null) {
            sb.append("(null)");
        } else {
            String sep = "";
            sb.append("[ ");
            for (String t : s) {
                sb.append(sep);
                sb.append(t);
                sep = ", ";
            }
            sb.append(" ]");
        }
        return sb.toString();
    }

    @Override
    public XmlElement start(String ... names) {
        if (!this.hasNext()) {
            throw new XmlException("at EOF but expected start element " + AbstractXmlPullParser.collapse(names));
        }
        XmlElement next = this.next();
        if (!next.isStart()) {
            throw new XmlException("got " + (next.isEnd() ? "end" : "content") + "element but expected start element " + AbstractXmlPullParser.collapse(names));
        }
        boolean found = names.length == 0;
        for (String name : names) {
            if (!name.equals(next.getName())) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new XmlException("got element " + next.getName() + " but expected start element " + AbstractXmlPullParser.collapse(names));
        }
        return next;
    }

    @Override
    public XmlElement softStart(String ... names) {
        if (!this.hasNext()) {
            throw new XmlException("at EOF but expected soft start element " + AbstractXmlPullParser.collapse(names));
        }
        XmlElement peek = this.peek();
        if (!peek.isStart()) {
            return null;
        }
        boolean found = names.length == 0;
        for (String name : names) {
            if (!name.equals(peek.getName())) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        return this.next();
    }

    @Override
    public int discardSubTree() {
        return this.discardSubTree(this.peek());
    }

    @Override
    public int discardSubTree(XmlElement element) {
        if (element == this.peek()) {
            if (element.isStart()) {
                String elementName = element.getName();
                int elementLevel = element.getLevel();
                XmlElement next = this.next();
                int count = 1;
                while (!next.isEnd() || next.getLevel() != elementLevel || !next.getName().equals(elementName)) {
                    next = this.next();
                    ++count;
                }
                return count;
            }
            this.next();
            return 1;
        }
        String elementName = element.getName();
        int elementLevel = element.getLevel();
        XmlElement peek = this.peek();
        int peekLevel = peek.getLevel();
        if (peekLevel < elementLevel) {
            return 0;
        }
        if (peekLevel == elementLevel) {
            if (element.isStart() && peek.isEnd() && element.getName().equals(peek.getName())) {
                this.next();
                return 1;
            }
            return 0;
        }
        XmlElement next = this.next();
        int count = 1;
        while (!next.isEnd() || next.getLevel() != elementLevel || !next.getName().equals(elementName)) {
            next = this.next();
            ++count;
        }
        return count;
    }

    @Override
    public int discardSubTree(String elementName) {
        XmlElement start = this.start(elementName);
        return this.discardSubTree(start) + 1;
    }
}

