/*
 * Decompiled with CFR 0.152.
 */
package utility.application;

import generic.jar.ResourceFile;
import ghidra.framework.ApplicationProperties;
import ghidra.framework.OperatingSystem;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class ApplicationUtilities {
    public static Collection<ResourceFile> findDefaultApplicationRootDirs() {
        ArrayList<ResourceFile> applicationRootDirs = new ArrayList<ResourceFile>();
        ResourceFile applicationRootDir = ApplicationUtilities.findPrimaryApplicationRootDir();
        if (applicationRootDir != null) {
            applicationRootDirs.add(applicationRootDir);
            if (SystemUtilities.isInTestingMode() || SystemUtilities.isInDevelopmentMode()) {
                applicationRootDirs.addAll(ApplicationUtilities.findApplicationRootDirsFromRepoConfig(applicationRootDir));
            }
        }
        return applicationRootDirs;
    }

    private static ResourceFile findPrimaryApplicationRootDir() {
        String[] classpath;
        for (String pathEntry : classpath = System.getProperty("java.class.path").split(File.pathSeparator)) {
            try {
                for (ResourceFile pathFile = new ResourceFile(new File(pathEntry).getCanonicalPath()); pathFile != null && pathFile.exists(); pathFile = pathFile.getParentFile()) {
                    if (!new ResourceFile(pathFile, "application.properties").exists()) continue;
                    return pathFile;
                }
            }
            catch (IOException e) {
                Msg.error(ApplicationUtilities.class, "Invalid class path entry: " + pathEntry, e);
            }
        }
        return null;
    }

    private static Collection<ResourceFile> findApplicationRootDirsFromRepoConfig(ResourceFile primaryApplicationRootDir) {
        ArrayList<ResourceFile> repoApplicationRootDirs = new ArrayList<ResourceFile>();
        ResourceFile repoConfigFile = new ResourceFile(primaryApplicationRootDir.getParentFile(), "ghidra.repos.config");
        if (repoConfigFile.isFile()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(repoConfigFile.getFile(false)));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    ResourceFile potentialApplicationRootDir;
                    if ((line = line.trim()).isEmpty() || line.startsWith("#") || !(potentialApplicationRootDir = new ResourceFile(repoConfigFile.getParentFile().getParentFile(), line + File.separator + "Ghidra")).isDirectory()) continue;
                    repoApplicationRootDirs.add(potentialApplicationRootDir);
                }
            }
            catch (IOException e) {
                Msg.error(ApplicationUtilities.class, "Failed to read: " + repoConfigFile);
            }
        }
        return repoApplicationRootDirs;
    }

    public static File getDefaultUserTempDir(ApplicationProperties applicationProperties) throws FileNotFoundException {
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (tmpdir == null || tmpdir.isEmpty()) {
            throw new FileNotFoundException("System property \"java.io.tmpdir\" is not set!");
        }
        return new File(tmpdir, SystemUtilities.getUserName() + "-" + applicationProperties.getApplicationName());
    }

    public static File getDefaultUserCacheDir(ApplicationProperties applicationProperties) throws FileNotFoundException {
        String cachedir = System.getProperty("application.cachedir");
        if (cachedir != null && !cachedir.isEmpty()) {
            return new File(cachedir, SystemUtilities.getUserName() + "-" + applicationProperties.getApplicationName());
        }
        if (OperatingSystem.CURRENT_OPERATING_SYSTEM == OperatingSystem.WINDOWS) {
            File localAppDataDir = null;
            String localAppDataDirPath = System.getenv("LOCALAPPDATA");
            if (localAppDataDirPath != null && !localAppDataDirPath.isEmpty()) {
                localAppDataDir = new File(localAppDataDirPath);
            } else {
                String userHome = System.getProperty("user.home");
                if (userHome != null && !(localAppDataDir = new File(userHome, "AppData\\Local")).isDirectory()) {
                    localAppDataDir = new File(userHome, "Local Settings");
                }
            }
            if (localAppDataDir != null && localAppDataDir.isDirectory()) {
                return new File(localAppDataDir, applicationProperties.getApplicationName());
            }
        }
        return ApplicationUtilities.getDefaultUserTempDir(applicationProperties);
    }

    public static File getDefaultUserSettingsDir(ApplicationProperties applicationProperties, ResourceFile installationDirectory) throws FileNotFoundException {
        String userSettingsDir = System.getProperty("user.home");
        if (userSettingsDir == null || userSettingsDir.isEmpty()) {
            throw new FileNotFoundException("System property \"user.home\" is not set!");
        }
        String prefix = "." + applicationProperties.getApplicationName().replaceAll("\\s", "").toLowerCase();
        File applicationParentDir = new File(userSettingsDir, prefix);
        String suffix = applicationProperties.getApplicationVersion();
        if (SystemUtilities.isInDevelopmentMode()) {
            suffix = suffix + "_location_" + installationDirectory.getName();
        }
        return new File(applicationParentDir, prefix + "-" + suffix);
    }
}

