/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcodeInject;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.template.OpTpl;
import ghidra.app.util.pcodeInject.ConstantPoolJava;
import ghidra.app.util.pcodeInject.InjectGetField;
import ghidra.app.util.pcodeInject.InjectGetStatic;
import ghidra.app.util.pcodeInject.InjectInvokeDynamic;
import ghidra.app.util.pcodeInject.InjectInvokeInterface;
import ghidra.app.util.pcodeInject.InjectInvokeSpecial;
import ghidra.app.util.pcodeInject.InjectInvokeStatic;
import ghidra.app.util.pcodeInject.InjectInvokeVirtual;
import ghidra.app.util.pcodeInject.InjectLdc;
import ghidra.app.util.pcodeInject.InjectLookupSwitch;
import ghidra.app.util.pcodeInject.InjectMultiANewArray;
import ghidra.app.util.pcodeInject.InjectPayloadJava;
import ghidra.app.util.pcodeInject.InjectPayloadJavaParameters;
import ghidra.app.util.pcodeInject.InjectPutField;
import ghidra.app.util.pcodeInject.InjectPutStatic;
import ghidra.pcodeCPort.slgh_compile.PcodeParser;
import ghidra.program.model.lang.ConstantPool;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.InjectPayloadSleigh;
import ghidra.program.model.lang.PcodeInjectLibrary;
import ghidra.program.model.listing.Program;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jdom.JDOMException;

public class PcodeInjectLibraryJava
extends PcodeInjectLibrary {
    public static final int CONSTANT_POOL_START_ADDRESS = 10;
    public static final String GETFIELD = "getFieldCallOther";
    public static final String GETSTATIC = "getStaticCallOther";
    public static final String INVOKE_DYNAMIC = "invokedynamicCallOther";
    public static final String INVOKE_INTERFACE = "invokeinterfaceCallOther";
    public static final String INVOKE_SPECIAL = "invokespecialCallOther";
    public static final String INVOKE_STATIC = "invokestaticCallOther";
    public static final String INVOKE_VIRTUAL = "invokevirtualCallOther";
    public static final String LDC = "ldcCallOther";
    public static final String LDC2_W = "ldc2_wCallOther";
    public static final String LDC_W = "ldc_wCallOther";
    public static final String LOOKUP_SWITCH = "lookupswitchCallOther";
    public static final String MULTIANEWARRAY = "multianewarrayCallOther";
    public static final String PUTFIELD = "putFieldCallOther";
    public static final String PUTSTATIC = "putStaticCallOther";
    public static final int REFERENCE_SIZE = 4;
    private SleighLanguage language;
    private Set<String> implementedOps;
    private PcodeParser parser;
    private InjectPayloadJavaParameters paramPayload;

    public PcodeInjectLibraryJava(SleighLanguage l) {
        super(l);
        this.language = l;
        this.implementedOps = new HashSet<String>();
        this.implementedOps.add(GETFIELD);
        this.implementedOps.add(GETSTATIC);
        this.implementedOps.add(INVOKE_DYNAMIC);
        this.implementedOps.add(INVOKE_INTERFACE);
        this.implementedOps.add(INVOKE_SPECIAL);
        this.implementedOps.add(INVOKE_STATIC);
        this.implementedOps.add(INVOKE_VIRTUAL);
        this.implementedOps.add(LDC);
        this.implementedOps.add(LDC2_W);
        this.implementedOps.add(LDC_W);
        this.implementedOps.add(LOOKUP_SWITCH);
        this.implementedOps.add(MULTIANEWARRAY);
        this.implementedOps.add(PUTFIELD);
        this.implementedOps.add(PUTSTATIC);
        String translateSpec = this.language.buildTranslatorTag(this.language.getAddressFactory(), this.getUniqueBase(), this.language.getSymbolTable());
        this.paramPayload = null;
        this.parser = null;
        try {
            this.parser = new PcodeParser(translateSpec);
        }
        catch (JDOMException e1) {
            e1.printStackTrace();
        }
    }

    protected InjectPayloadSleigh allocateInject(String sourceName, String name, int tp) {
        InjectPayloadJava payload = null;
        if (tp != 2) {
            return super.allocateInject(sourceName, name, tp);
        }
        switch (name) {
            case "getFieldCallOther": {
                payload = new InjectGetField(sourceName, this.language);
                break;
            }
            case "getStaticCallOther": {
                payload = new InjectGetStatic(sourceName, this.language);
                break;
            }
            case "invokedynamicCallOther": {
                payload = new InjectInvokeDynamic(sourceName, this.language);
                break;
            }
            case "invokeinterfaceCallOther": {
                payload = new InjectInvokeInterface(sourceName, this.language);
                break;
            }
            case "invokespecialCallOther": {
                payload = new InjectInvokeSpecial(sourceName, this.language);
                break;
            }
            case "invokestaticCallOther": {
                payload = new InjectInvokeStatic(sourceName, this.language);
                break;
            }
            case "invokevirtualCallOther": {
                payload = new InjectInvokeVirtual(sourceName, this.language);
                break;
            }
            case "ldcCallOther": 
            case "ldc2_wCallOther": 
            case "ldc_wCallOther": {
                payload = new InjectLdc(sourceName, this.language);
                break;
            }
            case "lookupswitchCallOther": {
                payload = new InjectLookupSwitch(sourceName, this.language);
                break;
            }
            case "multianewarrayCallOther": {
                payload = new InjectMultiANewArray(sourceName, this.language);
                break;
            }
            case "putFieldCallOther": {
                payload = new InjectPutField(sourceName, this.language);
                break;
            }
            case "putStaticCallOther": {
                payload = new InjectPutStatic(sourceName, this.language);
                break;
            }
            default: {
                return super.allocateInject(sourceName, name, 2);
            }
        }
        return payload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InjectPayload getPayload(int type, String name, Program program, String context) {
        if (type == 3) {
            if (this.paramPayload == null) {
                this.paramPayload = new InjectPayloadJavaParameters();
            }
            return this.paramPayload;
        }
        if (!this.implementedOps.contains(name)) {
            return super.getPayload(type, name, program, context);
        }
        InjectPayloadJava payload = (InjectPayloadJava)super.getPayload(2, name, program, context);
        PcodeParser pcodeParser = this.parser;
        synchronized (pcodeParser) {
            OpTpl[] opTemplates = payload.getPcode(this.parser, program, context);
            this.adjustUniqueBase(opTemplates);
            this.parser.clearSymbols();
        }
        return payload;
    }

    public ConstantPool getConstantPool(Program program) throws IOException {
        return new ConstantPoolJava(program);
    }
}

