/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.widgets.OptionDialog;
import ghidra.app.plugin.core.decompile.actions.RenameTask;
import ghidra.app.plugin.core.decompile.actions.RetypeVariableAction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.LocalSymbolMap;
import ghidra.program.model.pcode.PcodeException;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.awt.Component;

public class RenameVariableTask
extends RenameTask {
    private HighVariable var;
    private Varnode exactSpot;
    private HighFunction hfunction;
    private Program program;
    private Function function;
    private boolean commitRequired;
    private SourceType srctype;

    public RenameVariableTask(PluginTool tool, String old, HighFunction hfunc, HighVariable v, Varnode ex, SourceType st) {
        super(tool, old);
        this.var = v;
        this.exactSpot = ex;
        this.hfunction = hfunc;
        this.function = hfunc.getFunction();
        this.program = this.function.getProgram();
        this.srctype = st;
    }

    @Override
    public void commit() throws DuplicateNameException, InvalidInputException {
        if (this.commitRequired) {
            HighFunctionDBUtil.commitParamsToDatabase((HighFunction)this.hfunction, (boolean)true, (SourceType)this.srctype);
            HighFunctionDBUtil.commitReturnToDatabase((HighFunction)this.hfunction, (SourceType)this.srctype);
        }
        HighFunctionDBUtil.updateDBVariable((HighVariable)this.var, (String)this.newName, null, (SourceType)this.srctype);
    }

    @Override
    public boolean isValid(String newNm) {
        this.newName = newNm;
        LocalSymbolMap localSymbolMap = this.hfunction.getLocalSymbolMap();
        if (localSymbolMap.containsVariableWithName(this.newName) || this.isSymbolInFunction(this.newName)) {
            this.errorMsg = "Duplicate name";
            return false;
        }
        this.commitRequired = RetypeVariableAction.checkFullCommit(this.var, this.hfunction);
        if (this.commitRequired) {
            int resp = OptionDialog.showOptionDialog((Component)this.tool.getToolFrame(), (String)"Parameter Commit Required", (String)"Renaming a parameter requires all other parameters to be committed!\nContinue with rename?", (String)"Continue");
            if (resp != 1) {
                return false;
            }
            this.exactSpot = null;
        }
        if (this.exactSpot != null) {
            try {
                this.var = this.hfunction.splitOutMergeGroup(this.var, this.exactSpot);
            }
            catch (PcodeException e) {
                this.errorMsg = "Rename Failed: " + e.getMessage();
                return false;
            }
        }
        return true;
    }

    private boolean isSymbolInFunction(String name) {
        SymbolTable symbolTable = this.program.getSymbolTable();
        return !symbolTable.getSymbols(name, (Namespace)this.function).isEmpty();
    }

    @Override
    public String getTransactionName() {
        return "Rename Local Variable";
    }
}

