/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.Destination;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsclient.AsyncSendCallback;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MessageConvert;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.TemporaryDestination;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.CompletionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;

public class MessageProducerImpl
implements MessageProducer {
    protected boolean inClosing = false;
    protected boolean isClosed = false;
    protected boolean disableMessageId = false;
    protected boolean disableMessageTimestamp = false;
    protected int deliveryMode = 2;
    protected int priority = 4;
    protected long timeToLive = 0L;
    protected long deliveryDelay = 0L;
    protected javax.jms.Destination destination = null;
    protected SessionImpl session = null;
    protected MessageConvert messageConvert = null;
    protected javax.jms.Destination addProducerDest = null;
    protected Hashtable destinations = new Hashtable();
    protected Hashtable producerStates = new Hashtable();
    private boolean debug = Debug.debug;
    private boolean _forJMSBridge = false;
    protected static final Logger sessionLogger = SessionImpl.sessionLogger;

    public MessageProducerImpl(SessionImpl session, javax.jms.Destination destination) throws JMSException {
        try {
            this.session = session;
            this.destination = destination;
            if (destination != null) {
                session.getProtocolHandler().createMessageProducer(this);
            }
            session.addMessageProducer(this);
            if (sessionLogger.isLoggable(Level.FINE)) {
                this.logLifeCycle("I400");
            }
        }
        catch (JMSException jmse) {
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    public void recreateProducer() throws JMSException {
        if (this.destination != null) {
            this.session.getProtocolHandler().createMessageProducer(this);
        } else {
            Enumeration enum2 = this.destinations.elements();
            while (enum2.hasMoreElements()) {
                ProducerState ps = (ProducerState)enum2.nextElement();
                this.session.connection.removeMessageProducer(ps.getProducerID());
            }
            this.destinations.clear();
            this.producerStates.clear();
        }
    }

    protected Message checkJMQMessage(Message message) throws JMSException {
        if (message instanceof MessageImpl) {
            return message;
        }
        if (this.messageConvert == null) {
            this.messageConvert = MessageConvert.getInstance();
        }
        return this.messageConvert.convertJMSMessage(message);
    }

    protected void checkState() throws JMSException {
        IllegalStateException jmse;
        String errorString;
        if (this.inClosing) {
            errorString = AdministeredObject.cr.getKString("C4313");
            jmse = new IllegalStateException(errorString, "C4313");
            ExceptionHandler.throwJMSException((JMSException)((Object)jmse));
        }
        if (this.isClosed) {
            errorString = AdministeredObject.cr.getKString("C4064");
            jmse = new IllegalStateException(errorString, "C4064");
            ExceptionHandler.throwJMSException((JMSException)((Object)jmse));
        }
    }

    protected void resetForeignMessageHeader(Message message, Message foreignMessage) throws JMSException {
        if (!this._forJMSBridge) {
            this.messageConvert.resetForeignMessageHeader(message, foreignMessage);
        }
    }

    protected void writeJMSMessage(Message message, CompletionListener completionListener, Message foreignMessage) throws JMSException {
        this.writeJMSMessage(this.destination, message, completionListener, foreignMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeJMSMessage(javax.jms.Destination dest, Message message, CompletionListener completionListener, Message foreignMessage) throws JMSException {
        AsyncSendCallback asynccb = null;
        try {
            if (completionListener != null) {
                asynccb = new AsyncSendCallback(this, dest, message, completionListener, foreignMessage);
                this.session.addAsyncSendCallback(asynccb);
                this.checkState();
            }
            this.session.connection.checkReconnecting(null, true);
            this.checkFlowControl(dest, message, true);
            try {
                this.session.writeJMSMessage(message, asynccb);
                if (sessionLogger.isLoggable(Level.FINER)) {
                    this.logMessageProduced(dest, message, completionListener);
                }
                if (asynccb != null) {
                    asynccb.sendSuccessReturn();
                }
            }
            catch (Exception e) {
                ExceptionHandler.handleException(e, "C4038");
            }
        }
        finally {
            if (asynccb != null) {
                asynccb.sendReturn();
            }
        }
    }

    private void logMessageProduced(javax.jms.Destination dest, Message message, CompletionListener completionListener) throws JMSException {
        if (sessionLogger.isLoggable(Level.FINER)) {
            Destination mqDest = (Destination)dest;
            String domain = mqDest.isQueue() ? "Queue" : "Topic";
            String pktType = PacketType.getString(((MessageImpl)message).getPacket().getPacketType());
            ProducerState ps = (ProducerState)this.destinations.get(mqDest.getName());
            long pid = ps.getProducerID();
            String param = "MQTrace=MessageProducer, ThreadID=" + Thread.currentThread().getId() + ", ClientID=" + this.session.connection.getClientID() + ", ConnectionID=" + this.session.connection.getConnectionID() + ", SessionID=" + this.session.getBrokerSessionID() + ", ProducerID=" + pid + ", Destination=" + mqDest.getName() + ", Domain=" + domain + ", MessageID=" + message.getJMSMessageID() + ", MessageType=" + pktType;
            String logkey = "I402";
            if (completionListener != null) {
                logkey = "I403";
            }
            sessionLogger.log(Level.FINER, logkey, param);
            if (sessionLogger.isLoggable(Level.FINEST)) {
                param = "MQTrace=MessageProducer, ProducerID=" + pid + ", Message=" + message.toString();
                sessionLogger.log(Level.FINEST, logkey, param);
            }
        }
    }

    public javax.jms.Destination getDestination() throws JMSException {
        this.checkState();
        return this.destination;
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.checkState();
        this.disableMessageId = value;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkState();
        return this.disableMessageId;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.checkState();
        this.disableMessageTimestamp = value;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkState();
        return this.disableMessageTimestamp;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.checkState();
        if (deliveryMode != 1 && deliveryMode != 2) {
            String errorString = AdministeredObject.cr.getKString("C4051", "DeliveryMode", String.valueOf(deliveryMode));
            ExceptionHandler.throwJMSException(new JMSException(errorString, "C4051"));
        }
        this.deliveryMode = deliveryMode;
    }

    public int getDeliveryMode() throws JMSException {
        this.checkState();
        return this.deliveryMode;
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.checkState();
        if (defaultPriority < 0 || defaultPriority > 9) {
            String errorString = AdministeredObject.cr.getKString("C4051", "DeliveryPriority", String.valueOf(defaultPriority));
            ExceptionHandler.throwJMSException(new JMSException(errorString, "C4051"));
        }
        this.priority = defaultPriority;
    }

    public int getPriority() throws JMSException {
        this.checkState();
        return this.priority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.checkState();
        if (timeToLive < 0L) {
            String errorString = AdministeredObject.cr.getKString("C4051", "TimeToLive", String.valueOf(timeToLive));
            ExceptionHandler.throwJMSException(new JMSException(errorString, "C4051"));
        }
        this.timeToLive = timeToLive;
    }

    public long getTimeToLive() throws JMSException {
        this.checkState();
        return this.timeToLive;
    }

    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        this.checkState();
        if (deliveryDelay < 0L) {
            String errorString = AdministeredObject.cr.getKString("C4051", "DeliveryDelay", String.valueOf(deliveryDelay));
            ExceptionHandler.throwJMSException(new JMSException(errorString, "C4051"));
        }
        this.deliveryDelay = deliveryDelay;
    }

    public long getDeliveryDelay() throws JMSException {
        this.checkState();
        return this.deliveryDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        this.session.checkPermissionForAsyncSend();
        try {
            this.inClosing = true;
            try {
                Enumeration enum2 = this.producerStates.elements();
                while (enum2.hasMoreElements()) {
                    ProducerState ps = (ProducerState)enum2.nextElement();
                    if (this.session.connection.getBrokerProtocolLevel() >= 350 && this.session.getProtocolHandler() != null) {
                        this.session.connection.removeMessageProducer(ps.getProducerID());
                        if (!this.session.connection.isBroken()) {
                            this.session.getProtocolHandler().deleteMessageProducer(ps.getProducerID());
                        }
                    }
                    ps.close();
                }
                this.session.removeMessageProducer(this);
                this.destinations.clear();
                this.producerStates.clear();
            }
            finally {
                this.session.waitAllAsyncSendCompletion(this);
            }
        }
        finally {
            this.isClosed = true;
            if (SessionImpl.sessionLogger.isLoggable(Level.FINE)) {
                this.logLifeCycle("I401");
            }
        }
    }

    public void send(Message message) throws JMSException {
        this._send(message, null);
    }

    private void _send(Message message, CompletionListener completionListener) throws JMSException {
        Message foreignMessage = null;
        this.checkState();
        if (this.destination == null) {
            throw new UnsupportedOperationException();
        }
        this.checkTemporaryDestination(this.destination);
        if (!(message instanceof MessageImpl)) {
            foreignMessage = message;
        }
        message = this.checkJMQMessage(message);
        message.setJMSDestination(this.destination);
        message.setJMSDeliveryMode(this.getDeliveryMode());
        message.setJMSPriority(this.getPriority());
        message.setJMSExpiration(this.getTimeToLive());
        message.setJMSDeliveryTime(this.getDeliveryDelay());
        if (this.session.connection.jmqOverrideJMSMsgHeaders) {
            javax.jms.Destination d = message.getJMSDestination();
            if (this.session.connection.jmqOverrideMsgsToTempDests || !(d instanceof TemporaryQueue) && !(d instanceof TemporaryTopic)) {
                if (this.session.connection.jmqOverrideJMSDeliveryMode) {
                    message.setJMSDeliveryMode(this.session.connection.jmqJMSDeliveryMode);
                }
                if (this.session.connection.jmqOverrideJMSPriority) {
                    message.setJMSPriority(this.session.connection.jmqJMSPriority);
                }
                if (this.session.connection.jmqOverrideJMSExpiration) {
                    message.setJMSExpiration(this.session.connection.jmqJMSExpiration);
                }
            }
        }
        this.writeJMSMessage(message, completionListener, foreignMessage);
        if (foreignMessage != null && completionListener == null) {
            this.resetForeignMessageHeader(message, foreignMessage);
        }
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this._send(message, deliveryMode, priority, timeToLive, null);
    }

    private void _send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        Message foreignMessage = null;
        this.checkState();
        if (this.destination == null) {
            throw new UnsupportedOperationException();
        }
        this.checkTemporaryDestination(this.destination);
        if (!(message instanceof MessageImpl)) {
            foreignMessage = message;
        }
        message = this.checkJMQMessage(message);
        message.setJMSDestination(this.destination);
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        message.setJMSExpiration(timeToLive);
        message.setJMSDeliveryTime(this.getDeliveryDelay());
        if (this.session.connection.jmqOverrideJMSMsgHeaders) {
            javax.jms.Destination d = message.getJMSDestination();
            if (this.session.connection.jmqOverrideMsgsToTempDests || !(d instanceof TemporaryQueue) && !(d instanceof TemporaryTopic)) {
                if (this.session.connection.jmqOverrideJMSDeliveryMode) {
                    message.setJMSDeliveryMode(this.session.connection.jmqJMSDeliveryMode);
                }
                if (this.session.connection.jmqOverrideJMSPriority) {
                    message.setJMSPriority(this.session.connection.jmqJMSPriority);
                }
                if (this.session.connection.jmqOverrideJMSExpiration) {
                    message.setJMSExpiration(this.session.connection.jmqJMSExpiration);
                }
            }
        }
        this.writeJMSMessage(message, completionListener, foreignMessage);
        if (foreignMessage != null && completionListener == null) {
            this.resetForeignMessageHeader(message, foreignMessage);
        }
    }

    public void send(javax.jms.Destination destination, Message message) throws JMSException {
        this._send(destination, message, null);
    }

    private void _send(javax.jms.Destination destination, Message message, CompletionListener completionListener) throws JMSException {
        Message foreignMessage = null;
        this.checkState();
        if (destination == null) {
            String errorString = AdministeredObject.cr.getKString("C4019", "null");
            ExceptionHandler.throwJMSException((JMSException)((Object)new InvalidDestinationException(errorString, "C4019")));
        }
        if (this.destination != null) {
            throw new UnsupportedOperationException();
        }
        this.checkTemporaryDestination(destination);
        if (!(message instanceof MessageImpl)) {
            foreignMessage = message;
        }
        this.checkForUnspecifiedProducer(destination);
        message = this.checkJMQMessage(message);
        message.setJMSDestination(destination);
        message.setJMSDeliveryMode(this.getDeliveryMode());
        message.setJMSPriority(this.getPriority());
        message.setJMSExpiration(this.getTimeToLive());
        message.setJMSDeliveryTime(this.getDeliveryDelay());
        if (this.session.connection.jmqOverrideJMSMsgHeaders) {
            javax.jms.Destination d = message.getJMSDestination();
            if (this.session.connection.jmqOverrideMsgsToTempDests || !(d instanceof TemporaryQueue) && !(d instanceof TemporaryTopic)) {
                if (this.session.connection.jmqOverrideJMSDeliveryMode) {
                    message.setJMSDeliveryMode(this.session.connection.jmqJMSDeliveryMode);
                }
                if (this.session.connection.jmqOverrideJMSPriority) {
                    message.setJMSPriority(this.session.connection.jmqJMSPriority);
                }
                if (this.session.connection.jmqOverrideJMSExpiration) {
                    message.setJMSExpiration(this.session.connection.jmqJMSExpiration);
                }
            }
        }
        this.writeJMSMessage(destination, message, completionListener, foreignMessage);
        if (foreignMessage != null && completionListener == null) {
            this.resetForeignMessageHeader(message, foreignMessage);
        }
    }

    public void send(javax.jms.Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this._send(destination, message, deliveryMode, priority, timeToLive, null);
    }

    private void _send(javax.jms.Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        Message foreignMessage = null;
        this.checkState();
        if (destination == null) {
            String errorString = AdministeredObject.cr.getKString("C4019", "null");
            ExceptionHandler.throwJMSException((JMSException)((Object)new InvalidDestinationException(errorString, "C4019")));
        }
        if (this.destination != null) {
            throw new UnsupportedOperationException();
        }
        this.checkTemporaryDestination(destination);
        if (!(message instanceof MessageImpl)) {
            foreignMessage = message;
        }
        this.checkForUnspecifiedProducer(destination);
        message = this.checkJMQMessage(message);
        message.setJMSDestination(destination);
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        message.setJMSExpiration(timeToLive);
        message.setJMSDeliveryTime(this.getDeliveryDelay());
        if (this.session.connection.jmqOverrideJMSMsgHeaders) {
            javax.jms.Destination d = message.getJMSDestination();
            if (this.session.connection.jmqOverrideMsgsToTempDests || !(d instanceof TemporaryQueue)) {
                if (this.session.connection.jmqOverrideJMSDeliveryMode) {
                    message.setJMSDeliveryMode(this.session.connection.jmqJMSDeliveryMode);
                }
                if (this.session.connection.jmqOverrideJMSPriority) {
                    message.setJMSPriority(this.session.connection.jmqJMSPriority);
                }
                if (this.session.connection.jmqOverrideJMSExpiration) {
                    message.setJMSExpiration(this.session.connection.jmqJMSExpiration);
                }
            }
        }
        this.writeJMSMessage(destination, message, completionListener, foreignMessage);
        if (foreignMessage != null && completionListener == null) {
            this.resetForeignMessageHeader(message, foreignMessage);
        }
    }

    public void _setForJMSBridge() {
        this._forJMSBridge = true;
    }

    protected void setProducerID(javax.jms.Destination dest, long producerID) {
        String dn = ((Destination)dest).getName();
        ProducerState ps = (ProducerState)this.destinations.get(dn);
        if (ps == null) {
            ps = new ProducerState();
            this.destinations.put(dn, ps);
        } else {
            if (this.debug) {
                Debug.println("Replacing ProducerID. old = " + ps.getProducerID() + ", new = " + producerID);
            }
            this.producerStates.remove(ps.getProducerID());
            this.session.connection.removeMessageProducer(ps.getProducerID());
        }
        ps.setProducerID(producerID);
        this.producerStates.put(producerID, ps);
        this.session.connection.addMessageProducer(producerID, this);
    }

    protected void setFlowLimit(long producerID, int flowLimit) {
        if (this.debug) {
            Debug.println("Setting flowLimit = " + flowLimit + " for producerID = " + producerID);
        }
        ProducerState ps = (ProducerState)this.producerStates.get(producerID);
        ps.setFlowLimit(flowLimit);
    }

    protected void setFlowBytesLimit(long producerID, long flowBytesLimit) {
        if (this.debug) {
            Debug.println("Setting flowBytesLimit = " + flowBytesLimit + " for producerID = " + producerID);
        }
        ProducerState ps = (ProducerState)this.producerStates.get(producerID);
        ps.setFlowBytesLimit(flowBytesLimit);
    }

    private void checkFlowControl(javax.jms.Destination dest, Message message, boolean block) throws JMSException {
        String dn = ((Destination)dest).getName();
        ProducerState ps = (ProducerState)this.destinations.get(dn);
        if (ps != null) {
            ps.checkFlowControl(message, block);
        }
    }

    protected SessionImpl getSession() {
        return this.session;
    }

    public String toString() {
        long pid;
        String destName;
        block3: {
            destName = null;
            pid = -1L;
            try {
                if (this.destination != null) {
                    destName = ((Destination)this.destination).getName();
                    ProducerState ps = (ProducerState)this.destinations.get(destName);
                    pid = ps.getProducerID();
                }
            }
            catch (Exception e) {
                if (!this.debug) break block3;
                Debug.printStackTrace(e);
            }
        }
        return this.session.toString() + ", ProducerID=" + pid + ", DestName=" + destName;
    }

    protected void checkForUnspecifiedProducer(javax.jms.Destination dest) throws JMSException {
        Destination d = (Destination)dest;
        String dn = d.getName();
        if (this.destinations.get(dn) == null) {
            this.session.getProtocolHandler().createMessageProducer(this, d);
        }
    }

    protected void checkTemporaryDestination(javax.jms.Destination dest) throws JMSException {
        if (dest instanceof TemporaryDestination) {
            ConnectionImpl connection;
            if (((TemporaryDestination)dest).isDeleted()) {
                String errorString = AdministeredObject.cr.getKString("C4111", ((TemporaryDestination)dest).getName());
                ExceptionHandler.throwJMSException((JMSException)((Object)new InvalidDestinationException(errorString, "C4111")));
            }
            if ((connection = ((TemporaryDestination)dest).connection) != null && connection.isClosed) {
                String errorString = AdministeredObject.cr.getKString("C4020", ((TemporaryDestination)dest).getName());
                ExceptionHandler.throwJMSException((JMSException)((Object)new InvalidDestinationException(errorString, "C4020")));
            }
        }
    }

    public void logLifeCycle(String key) {
        if (sessionLogger.isLoggable(Level.FINE)) {
            sessionLogger.log(Level.FINE, key, this);
        }
    }

    protected Hashtable getDebugState(boolean verbose) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("isClosed", String.valueOf(this.isClosed));
        ht.put("deliveryMode", String.valueOf(this.deliveryMode));
        ht.put("priority", String.valueOf(this.priority));
        ht.put("timeToLive", String.valueOf(this.timeToLive));
        ht.put("deliveryDelay", String.valueOf(this.deliveryDelay));
        ht.put("disableMessageId", String.valueOf(this.disableMessageId));
        ht.put("disableTimestamp", String.valueOf(this.disableMessageTimestamp));
        if (this.destination != null) {
            ht.put("Destination Class", this.destination.getClass().getName());
            if (this.destination instanceof Destination) {
                ht.put("Destination", ((Destination)this.destination).getName());
            }
            Enumeration enum2 = this.producerStates.elements();
            while (enum2.hasMoreElements()) {
                ProducerState ps = (ProducerState)enum2.nextElement();
                ht.putAll(ps.getDebugState(verbose));
            }
        } else {
            ht.put("isBound", "false");
            ht.put("# Destinations", String.valueOf(this.destinations.size()));
            int n = 0;
            Enumeration enum2 = this.destinations.keys();
            while (enum2.hasMoreElements()) {
                String dn = (String)enum2.nextElement();
                ProducerState ps = (ProducerState)this.destinations.get(dn);
                Hashtable tmp = ps.getDebugState(verbose);
                tmp.put("Destination", dn);
                ht.put("ProducerState[" + n + "]", tmp);
                ++n;
            }
        }
        return ht;
    }

    public void send(Message message, CompletionListener completionListener) throws JMSException {
        if (completionListener == null) {
            throw new IllegalArgumentException("CompletionListener must not be null");
        }
        this._send(message, completionListener);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        if (completionListener == null) {
            throw new IllegalArgumentException("CompletionListener must not be null");
        }
        this._send(message, deliveryMode, priority, timeToLive, completionListener);
    }

    public void send(javax.jms.Destination destination, Message message, CompletionListener completionListener) throws JMSException {
        if (completionListener == null) {
            throw new IllegalArgumentException("CompletionListener must not be null");
        }
        this._send(destination, message, completionListener);
    }

    public void send(javax.jms.Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        if (completionListener == null) {
            throw new IllegalArgumentException("CompletionListener must not be null");
        }
        this._send(destination, message, deliveryMode, priority, timeToLive, completionListener);
    }

    class ProducerState {
        private long flowBytesLimit;
        private int flowLimit;
        private long producerID;
        private boolean blocked = false;
        private boolean _psclosed = false;
        private int TEST_minResume = Integer.MAX_VALUE;
        private int TEST_maxResume = -1;
        private int TEST_resumeCount = 0;
        private int TEST_pauseCount = 0;
        private int TEST_forcePauseCount = 0;

        ProducerState() {
        }

        protected long getFlowBytesLimit() {
            return this.flowBytesLimit;
        }

        protected synchronized void setFlowBytesLimit(long flowBytesLimit) {
            this.flowBytesLimit = flowBytesLimit;
        }

        protected int getFlowLimit() {
            return this.flowLimit;
        }

        protected synchronized void setFlowLimit(int flowLimit) {
            this.flowLimit = flowLimit;
            if (flowLimit < this.TEST_minResume) {
                this.TEST_minResume = flowLimit;
            }
            if (flowLimit > this.TEST_maxResume) {
                this.TEST_maxResume = flowLimit;
            }
            if (flowLimit != 0) {
                ++this.TEST_resumeCount;
            } else {
                ++this.TEST_forcePauseCount;
            }
            this.notifyAll();
        }

        protected long getProducerID() {
            return this.producerID;
        }

        protected void setProducerID(long producerID) {
            this.producerID = producerID;
        }

        protected synchronized void close() {
            this._psclosed = true;
            this.notifyAll();
        }

        private synchronized void checkFlowControl(Message message, boolean block) throws JMSException {
            while (this.flowLimit == 0 && !MessageProducerImpl.this.isClosed && !this._psclosed) {
                try {
                    if (!block) {
                        throw new JMSException("XXXWOULD-BLOCK");
                    }
                    this.blocked = true;
                    this.wait();
                    this.blocked = false;
                }
                catch (InterruptedException interruptedException) {}
            }
            if (MessageProducerImpl.this.isClosed || this._psclosed) {
                String errorString = AdministeredObject.cr.getKString("C4064");
                JMSException jmse = new JMSException(errorString, "C4064");
                ExceptionHandler.throwJMSException(jmse);
            }
            if (this.flowLimit > 0) {
                --this.flowLimit;
            }
            if (this.flowLimit == 0) {
                ++this.TEST_pauseCount;
            }
            ReadWritePacket pkt = ((MessageImpl)message).getPacket();
            pkt.setProducerID(this.producerID);
            pkt.setConsumerFlow(this.flowLimit == 0);
        }

        protected Hashtable getDebugState(boolean verbose) {
            Hashtable<String, String> ht = new Hashtable<String, String>();
            ht.put("producerID", String.valueOf(this.producerID));
            ht.put("flowLimit", String.valueOf(this.flowLimit));
            ht.put("flowBytesLimit", String.valueOf(this.flowBytesLimit));
            ht.put("blocked", String.valueOf(this.blocked));
            ht.put("pauseCount", String.valueOf(this.TEST_pauseCount));
            ht.put("resumeCount", String.valueOf(this.TEST_resumeCount));
            ht.put("maxResume", String.valueOf(this.TEST_maxResume));
            ht.put("minResume", String.valueOf(this.TEST_minResume));
            ht.put("forcedPauses", String.valueOf(this.TEST_forcePauseCount));
            return ht;
        }
    }
}

