/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jms.ra.ActivationSpec;
import com.sun.messaging.jms.ra.EndpointConsumer;
import com.sun.messaging.jms.ra.OnMessageRunner;
import com.sun.messaging.jms.ra.OnMessageRunnerPool;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

public class MessageListener
implements javax.jms.MessageListener {
    private EndpointConsumer epConsumer = null;
    private MessageEndpointFactory epFactory = null;
    private ActivationSpec spec = null;
    private MessageEndpoint msgEndpoint = null;
    private XAResource xar = null;
    private Method onMessage = null;
    private OnMessageRunnerPool omrPool = null;
    private boolean transactedDelivery = false;
    private boolean noAckDelivery = false;
    private boolean useRADirect = false;
    private static final transient String _className = "com.sun.messaging.jms.ra.ConnectionFactoryAdapter";
    protected static final transient String _lgrNameInboundMessage = "javax.resourceadapter.mqjmsra.inbound.message";
    protected static final transient Logger _loggerIM = Logger.getLogger("javax.resourceadapter.mqjmsra.inbound.message");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_ML";
    protected static final transient String _lgrMID_EET = "MQJMSRA_ML1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_ML1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_ML2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_ML3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_ML4001: ";

    public MessageListener(EndpointConsumer epConsumer, MessageEndpointFactory epFactory, ActivationSpec spec) {
        this(epConsumer, epFactory, spec, false, false);
    }

    public MessageListener(EndpointConsumer epConsumer, MessageEndpointFactory epFactory, ActivationSpec spec, boolean noAckDelivery) {
        this(epConsumer, epFactory, spec, noAckDelivery, false);
    }

    public MessageListener(EndpointConsumer epConsumer, MessageEndpointFactory epFactory, ActivationSpec spec, boolean noAckDelivery, boolean useRADirect) {
        Object[] params = new Object[]{epConsumer, epFactory, spec, noAckDelivery, useRADirect};
        _loggerIM.entering(_className, "constructor()", params);
        this.epConsumer = epConsumer;
        this.epFactory = epFactory;
        this.spec = spec;
        this.noAckDelivery = noAckDelivery;
        this.useRADirect = useRADirect;
        this.onMessage = epConsumer.getResourceAdapter()._getOnMessageMethod();
        this.xar = !useRADirect ? epConsumer.getXASession().getXAResource() : null;
        try {
            this.transactedDelivery = epFactory.isDeliveryTransacted(this.onMessage);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void waitForAllOnMessageRunners() throws JMSException {
        if (this.omrPool != null) {
            this.omrPool.waitForAllOnMessageRunners();
        }
    }

    public void releaseOnMessageRunners() {
        if (this.omrPool != null) {
            this.omrPool.releaseOnMessageRunners();
        }
    }

    public void invalidateOnMessageRunners() {
        if (this.omrPool != null) {
            this.omrPool.invalidateOnMessageRunners();
        }
    }

    public void onMessage(Message message) {
        if (!this.useRADirect) {
            if (this.epConsumer.xas.isRemoteAckFailed()) {
                this.recreateConsumer();
                return;
            }
            ((MessageImpl)message)._setConsumerInRA();
            if (this.spec._deliverySerial()) {
                this._onMessage(message);
                return;
            }
        }
        if (this.omrPool == null) {
            this.omrPool = new OnMessageRunnerPool(this.epFactory, this.epConsumer, this.spec, this.useRADirect);
        }
        try {
            OnMessageRunner omr = this.omrPool.getOnMessageRunner();
            omr.onMessage(message);
        }
        catch (JMSException jmse) {
            System.err.println("MQRA:ML:onMessage:JMSException on getOnMessageRunner");
            jmse.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _onMessage(Message message) {
        assert (!this.useRADirect);
        MessageImpl mqmsg = (MessageImpl)message;
        SessionImpl mqsess = (SessionImpl)this.epConsumer.getXASession();
        try {
            this.transactedDelivery = this.epFactory.isDeliveryTransacted(this.onMessage);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.msgEndpoint = null;
        for (int i = 1; i < 6; ++i) {
            try {
                if (this.epConsumer.deactivated) continue;
                this.msgEndpoint = this.epFactory.createEndpoint(this.xar);
                break;
            }
            catch (UnavailableException ue) {
                try {
                    Thread.sleep((long)i * 200L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.msgEndpoint == null) {
            System.err.println("MQRA:ML:Endpoint Unavailable:Shutting down delivery for " + this.spec.toString());
            mqmsg._getSession().closeFromRA();
            return;
        }
        ClassLoader cl = this.spec.getContextClassLoader();
        int exRedeliveryAttempts = this.spec.getEndpointExceptionRedeliveryAttempts();
        int exRedeliveryInterval = this.spec.getEndpointExceptionRedeliveryInterval();
        boolean redeliver = true;
        while (redeliver) {
            try {
                if (this.transactedDelivery) {
                    this.msgEndpoint.beforeDelivery(this.onMessage);
                }
                try {
                    if (cl != null) {
                        try {
                            Thread.currentThread().setContextClassLoader(cl);
                        }
                        catch (Exception sccle) {
                            System.err.println("MQRA:ML:Exception setting ContextClassLoader:" + sccle.getMessage());
                        }
                    }
                    ((javax.jms.MessageListener)this.msgEndpoint).onMessage(message);
                    redeliver = false;
                    try {
                        mqsess.acknowledgeFromRAEndpoint(mqmsg);
                    }
                    catch (JMSException jmse) {
                        System.err.println("MQRA:ML:JMSException on acknowledge");
                    }
                }
                catch (Exception rte) {
                    System.err.println("MQRA:ML:Caught Exception from onMessage():" + rte.getMessage());
                    if (exRedeliveryAttempts > 0) {
                        try {
                            Thread.sleep(exRedeliveryInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        --exRedeliveryAttempts;
                    }
                    System.err.println("MQRA:ML:Exhausted redeliveryAttempts-shutting down delivery for " + this.spec.toString());
                    redeliver = false;
                    mqmsg._getSession().closeFromRA();
                }
                if (!this.transactedDelivery) continue;
                this.msgEndpoint.afterDelivery();
            }
            catch (Throwable t) {
                System.err.println("MQRA:ML:onMessage caught Throwable-before/on/afterDelivery:Class=" + t.getClass().getName() + "Msg=" + t.getMessage());
                redeliver = false;
                mqmsg._getSession().closeFromRA();
            }
            finally {
                try {
                    this.msgEndpoint.release();
                }
                catch (Exception rte) {}
            }
        }
    }

    private void recreateConsumer() {
        try {
            this.waitForAllOnMessageRunners();
            this.epConsumer.xas.recreateConsumerForRA();
        }
        catch (Exception jmse) {
            this.epConsumer.xas.logException(jmse);
        }
    }
}

