/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.messaging;

import com.sun.messaging.jmq.resources.SharedResources;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.MissingResourceException;
import java.util.Properties;
import javax.xml.messaging.JAXMException;

class FactoryFinder {
    private static final transient SharedResources cr = SharedResources.getResources();

    FactoryFinder() {
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws JAXMException {
        String emsg = "";
        try {
            emsg = cr.getKString("S4007", className);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            Class<?> spiClass = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
            return spiClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new JAXMException(emsg);
        }
        catch (Exception x) {
            throw new JAXMException(emsg);
        }
    }

    static Object find(String factoryId, String fallbackClassName) throws JAXMException {
        ClassLoader classLoader;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception x) {
            throw new JAXMException(x.toString(), x);
        }
        try {
            String systemProp = System.getProperty(factoryId);
            if (systemProp != null) {
                return FactoryFinder.newInstance(systemProp, classLoader);
            }
        }
        catch (SecurityException systemProp) {
            // empty catch block
        }
        try {
            String javah = System.getProperty("java.home");
            String configFile = javah + File.separator + "lib" + File.separator + "jaxm.properties";
            File f = new File(configFile);
            if (f.exists()) {
                Properties props = new Properties();
                props.load(new FileInputStream(f));
                String factoryClassName = props.getProperty(factoryId);
                return FactoryFinder.newInstance(factoryClassName, classLoader);
            }
        }
        catch (Exception javah) {
            // empty catch block
        }
        String serviceId = "META-INF/services/" + factoryId;
        try {
            InputStream is = null;
            is = classLoader == null ? ClassLoader.getSystemResourceAsStream(serviceId) : classLoader.getResourceAsStream(serviceId);
            if (is != null) {
                BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                String factoryClassName = rd.readLine();
                rd.close();
                if (factoryClassName != null && !"".equals(factoryClassName)) {
                    return FactoryFinder.newInstance(factoryClassName, classLoader);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fallbackClassName == null) {
            throw new JAXMException("Provider for " + factoryId + " cannot be found", null);
        }
        return FactoryFinder.newInstance(fallbackClassName, classLoader);
    }
}

