/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver;

import com.sun.messaging.jmq.jmsserver.BrokerProcess;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQEmbeddedService;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsservice.BrokerEventListener;
import com.sun.messaging.jmq.jmsservice.DirectBrokerConnection;
import com.sun.messaging.jmq.jmsservice.JMSDirectBroker;
import java.util.Properties;

public class DirectBrokerProcess
extends BrokerProcess
implements JMSDirectBroker {
    String name = "mqdirect";

    @Override
    public int start(boolean inProcess, Properties properties, BrokerEventListener bel, boolean initOnly, Throwable failStartThrowable) throws OutOfMemoryError, IllegalStateException, IllegalArgumentException {
        if (properties == null) {
            properties = new Properties();
        }
        properties.put("imq.service.runtimeAdd", this.name);
        return super.start(inProcess, properties, bel, initOnly, failStartThrowable);
    }

    @Override
    public boolean directServiceIsUp() {
        IMQService service = (IMQService)Globals.getServiceManager().getService(this.name);
        if (service == null) {
            return false;
        }
        return service.getState() == 3;
    }

    @Override
    public DirectBrokerConnection getConnection() {
        IMQEmbeddedService service = (IMQEmbeddedService)Globals.getServiceManager().getService(this.name);
        try {
            return service.createConnection();
        }
        catch (Exception ex) {
            Globals.getLogger().logStack(16, "L10N-XXX: Unable to create connection", (Throwable)ex);
            return null;
        }
    }
}

