/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.Queue;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class GetBrokerPropsHandler
extends AdminCmdHandler {
    private static boolean DEBUG = GetBrokerPropsHandler.getDEBUG();

    public GetBrokerPropsHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        ClusteredBroker cb;
        int status = 200;
        String emsg = null;
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + cmd_props);
        }
        Properties brokerProps = Globals.getConfig().toProperties();
        Version version = Globals.getVersion();
        brokerProps.putAll((Map<?, ?>)version.getProps());
        try {
            this.addLicenseInfo(brokerProps);
        }
        catch (Exception ex) {
            this.logger.log(16, "B4257", (Throwable)ex);
        }
        GetBrokerPropsHandler getBrokerPropsHandler = this;
        brokerProps.put("imq.system.current_count", String.valueOf(getBrokerPropsHandler.DL.totalCount()));
        GetBrokerPropsHandler getBrokerPropsHandler2 = this;
        brokerProps.put("imq.system.current_size", String.valueOf(getBrokerPropsHandler2.DL.totalBytes()));
        Queue[] qs = DestinationList.getDMQ(null);
        Queue dmq = qs[0];
        brokerProps.put("imq.dmq.current_count", String.valueOf(dmq.size()));
        brokerProps.put("imq.dmq.current_size", String.valueOf(dmq.byteSize()));
        String val = brokerProps.getProperty("imq.autocreate.destination.useDMQ");
        if (val == null || val.trim().equals("")) {
            brokerProps.put("imq.autocreate.destination.useDMQ", String.valueOf(DestinationList.defaultUseDMQ));
        }
        if (Globals.getBrokerID() != null) {
            brokerProps.put("imq.brokerid", Globals.getBrokerID());
        } else if (Globals.isBDBStore() && !Globals.getSFSHAEnabled()) {
            ClusteredBroker cb2 = null;
            try {
                cb2 = Globals.getClusterManager().getLocalBroker();
                brokerProps.put("imq.brokerid", cb2.getNodeName());
            }
            catch (Exception e) {
                this.logger.logStack(16, e.getMessage(), (Throwable)e);
            }
        }
        if (Globals.getClusterID() != null) {
            brokerProps.put("imq.cluster.clusterid", Globals.getClusterID());
        }
        if (Globals.getBDBREPEnabled()) {
            brokerProps.put("imq.persist.bdb.replication.enabled", "true");
        }
        if (Globals.isBDBStore()) {
            brokerProps.put("imq.storemigratable", "true");
        }
        GetBrokerPropsHandler getBrokerPropsHandler3 = this;
        if (getBrokerPropsHandler3.DL.isPartitionMode()) {
            GetBrokerPropsHandler getBrokerPropsHandler4 = this;
            if (getBrokerPropsHandler4.DL.isPartitionMigratable()) {
                brokerProps.put("imq.partitionmigratable", "true");
            }
        }
        brokerProps.put("imq.embedded", Boolean.toString(Broker.isInProcess()));
        if (Globals.getHAEnabled() && !Globals.getSFSHAEnabled()) {
            brokerProps.put("imq.cluster.masterbroker", "");
        } else if (Globals.useSharedConfigRecord()) {
            String shareccVendor = null;
            try {
                shareccVendor = Globals.getStore().getShareConfigChangeStore().getVendorPropertySetting();
            }
            catch (BrokerException e) {
                this.logger.logStack(16, e.getMessage(), (Throwable)e);
            }
            brokerProps.put("imq.cluster.masterbroker", "[imq.cluster.nomasterbroker=" + brokerProps.get("imq.cluster.nomasterbroker") + ", " + shareccVendor + "]");
        }
        ClusterManager cfg = Globals.getClusterManager();
        String list = null;
        Iterator itr = cfg.getConfigBrokers();
        HashSet<String> s = new HashSet<String>();
        while (itr.hasNext()) {
            cb = (ClusteredBroker)itr.next();
            s.add(cb.getBrokerURL().toString());
        }
        itr = s.iterator();
        while (itr.hasNext()) {
            if (list == null) {
                list = itr.next().toString();
                continue;
            }
            list = list + "," + itr.next().toString();
        }
        if (list == null) {
            list = "";
        }
        brokerProps.put("imq.cluster.brokerlist", list);
        list = null;
        s = new HashSet();
        itr = cfg.getActiveBrokers();
        while (itr.hasNext()) {
            cb = (ClusteredBroker)itr.next();
            s.add(cb.getBrokerURL().toString());
        }
        itr = s.iterator();
        while (itr.hasNext()) {
            if (list == null) {
                list = itr.next().toString();
                continue;
            }
            list = list + "," + itr.next().toString();
        }
        if (list == null) {
            list = "";
        }
        brokerProps.put("imq.cluster.brokerlist.active", list);
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        GetBrokerPropsHandler.setProperties(reply, 55, status, emsg);
        this.setBodyObject(reply, brokerProps);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }

    private void addLicenseInfo(Properties brokerProps) throws BrokerException {
        LicenseBase license = null;
        license = Globals.getCurrentLicense(null);
        brokerProps.put("imq.license.description", license.getProperty("description"));
    }
}

