/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.PreparedTxnStore;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionLogManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.WaitTimeoutException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BaseTransactionManager {
    public static final Logger logger = Globals.getLogger();
    PreparedTxnStore preparedTxnStore;
    TransactionLogManager transactionLogManager;
    Set<TransactionUID> playingToMessageStore = Collections.synchronizedSet(new HashSet());
    Map<TransactionUID, BaseTransaction> completeStored = new Hashtable<TransactionUID, BaseTransaction>();
    Map<TransactionUID, BaseTransaction> incompleteUnstored = new Hashtable<TransactionUID, BaseTransaction>();
    Map<TransactionUID, BaseTransaction> incompleteStored = new Hashtable<TransactionUID, BaseTransaction>();

    BaseTransactionManager(TransactionLogManager transactionLogManager) {
        this.transactionLogManager = transactionLogManager;
        this.preparedTxnStore = transactionLogManager.preparedTxnStore;
    }

    abstract String getPrefix();

    public List<BaseTransaction> getAllIncompleteTransactions() {
        ArrayList<BaseTransaction> result = new ArrayList<BaseTransaction>();
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " getAllIncompleteTransactions   num incompleteUnstored = " + this.incompleteUnstored.size() + " num incompleteStored = " + this.incompleteStored.size();
            logger.log(4, msg);
        }
        result.addAll(this.incompleteUnstored.values());
        result.addAll(this.incompleteStored.values());
        return result;
    }

    public HashMap getAllTransactionsMap() {
        List<BaseTransaction> txns = this.getAllIncompleteTransactions();
        HashMap<TransactionUID, TransactionState> map = new HashMap<TransactionUID, TransactionState>(txns.size());
        for (BaseTransaction txn : txns) {
            TransactionState txnState = new TransactionState(txn.getTransactionState());
            map.put(txn.getTid(), txnState);
        }
        return map;
    }

    public void addToCompleteStored(BaseTransaction baseTxn) {
        this.completeStored.put(baseTxn.getTid(), baseTxn);
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " adding  " + baseTxn.getTid() + "  to completeStored. Total = " + this.completeStored.size();
            logger.log(4, msg);
        }
    }

    public void removeFromCompleteStored(TransactionUID tid) {
        this.completeStored.remove(tid);
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " removing " + tid + " from completeStored. Total = " + this.completeStored.size();
            logger.log(4, msg);
        }
    }

    void addToIncompleteStored(BaseTransaction baseTxn) {
        this.incompleteStored.put(baseTxn.getTid(), baseTxn);
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " adding  " + baseTxn.getTid() + "  to incompleteStored. Total = " + this.incompleteStored.size();
            logger.log(4, msg);
        }
    }

    BaseTransaction removeFromIncompleteStored(TransactionUID tid) {
        BaseTransaction result = this.incompleteStored.remove(tid);
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " removing  " + tid + " from incompleteStored. Total = " + this.incompleteStored.size();
            logger.log(4, msg);
        }
        return result;
    }

    void addToIncompleteUnstored(BaseTransaction baseTxn) {
        this.incompleteUnstored.put(baseTxn.getTid(), baseTxn);
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " adding  " + baseTxn.getTid() + "  to incompleteUnstored. Total = " + this.incompleteUnstored.size();
            logger.log(4, msg);
        }
    }

    BaseTransaction removeFromIncompleteUnstored(TransactionUID tid) {
        BaseTransaction result = this.incompleteUnstored.remove(tid);
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " removing  " + tid + " from incompleteUnstored. Total = " + this.incompleteUnstored.size();
            logger.log(4, msg);
        }
        return result;
    }

    abstract void processStoredTxnOnStartup(BaseTransaction var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForPlayingToMessageStoreCompletion(boolean nowait) throws WaitTimeoutException {
        Set<TransactionUID> set = this.playingToMessageStore;
        synchronized (set) {
            String msg;
            if (Store.getDEBUG()) {
                msg = this.getPrefix() + " num playingToMessageStore =" + this.playingToMessageStore.size();
                logger.log(4, msg);
            }
            try {
                while (this.playingToMessageStore.size() > 0) {
                    if (Store.getDEBUG()) {
                        msg = this.getPrefix() + " waiting for " + this.playingToMessageStore.size() + " playingToMessageStore";
                        logger.log(4, msg);
                    }
                    if (nowait) {
                        throw new WaitTimeoutException(this.getClass().getSimpleName());
                    }
                    this.playingToMessageStore.wait(1000L);
                }
                this.transactionLogManager.notifyPlayToStoreCompletion();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playingToMessageStoreComplete(TransactionUID tid) {
        Object msg;
        if (Store.getDEBUG()) {
            msg = this.getPrefix() + " playingToMessageStoreComplete " + tid;
            logger.log(4, (String)msg);
        }
        msg = this.playingToMessageStore;
        synchronized (msg) {
            Boolean found = this.playingToMessageStore.remove(tid);
            if (found == null) {
                String msg2 = this.getPrefix() + " playingToMessageStoreComplete(): could not find " + tid;
                logger.log(16, msg2);
            }
            this.playingToMessageStore.notifyAll();
        }
        if (Store.getDEBUG()) {
            msg = this.getPrefix() + " remove transaction from  playingToMessageStore. tid=" + tid + " size = " + this.playingToMessageStore.size();
            logger.log(4, (String)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writePreparedTransactionsToPreparedTxnStoreOnCheckpoint() throws BrokerException {
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " writePreparedTransactionsToPreparedTxnStoreOnCheckpoint num incompleteUnstored=" + this.incompleteUnstored.size();
            logger.log(4, msg);
        }
        ArrayList<TransactionUID> incmps = null;
        Map<TransactionUID, BaseTransaction> map = this.incompleteUnstored;
        synchronized (map) {
            incmps = new ArrayList<TransactionUID>(this.incompleteUnstored.keySet());
        }
        TransactionUID tid2 = null;
        BaseTransaction baseTxn = null;
        for (TransactionUID tid2 : incmps) {
            String msg;
            if (!this.preparedTxnStore.containsTransaction(tid2)) {
                baseTxn = this.incompleteUnstored.get(tid2);
                if (baseTxn == null) continue;
                if (Store.getDEBUG()) {
                    msg = this.getPrefix() + " transaction storing preparedTransaction " + baseTxn;
                    logger.log(4, msg);
                }
                try {
                    this.preparedTxnStore.storeTransaction(baseTxn, true);
                    this.addToIncompleteStored(baseTxn);
                    continue;
                }
                catch (IOException ioe) {
                    throw new BrokerException("failed to store transaction in preparedTxnStore " + baseTxn, ioe);
                }
            }
            msg = this.getPrefix() + " transaction already exists in preparedTxnStore " + tid2 + "[" + this.incompleteUnstored.get(tid2) + "]";
            logger.log(8, msg);
        }
        this.incompleteUnstored.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCompleteTransactionsAfterCheckpoint() throws BrokerException {
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " removeCompleteTransactionsAfterCheckpointnum completeStored=" + this.completeStored.size();
            logger.log(4, msg);
        }
        ArrayList<TransactionUID> cmptids = null;
        Map<TransactionUID, BaseTransaction> map = this.completeStored;
        synchronized (map) {
            cmptids = new ArrayList<TransactionUID>(this.completeStored.keySet());
        }
        for (TransactionUID tid : cmptids) {
            String msg;
            if (this.preparedTxnStore.containsTransaction(tid)) {
                this.preparedTxnStore.removeTransaction(tid, true);
                if (!Store.getDEBUG()) continue;
                msg = this.getPrefix() + " removed transaction " + tid;
                logger.log(4, msg);
                continue;
            }
            if (!Store.getDEBUG()) continue;
            msg = this.getPrefix() + " Could not find transaction in preparedTxnStore " + tid;
            logger.log(4, msg);
        }
        this.completeStored.clear();
    }

    void rollbackAllTransactions() {
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " rollbackAllTransactions num incompleteStored=" + this.incompleteStored.size() + " num incompleteUnstored=" + this.incompleteUnstored.size();
            logger.log(4, msg);
        }
        Collection<BaseTransaction> storedTxns = this.incompleteStored.values();
        ArrayList<BaseTransaction> storedTxnsCopy = new ArrayList<BaseTransaction>(storedTxns);
        this.rollbackTransactions(storedTxnsCopy);
        Collection<BaseTransaction> unstoredTxns = this.incompleteUnstored.values();
        ArrayList<BaseTransaction> unstoredTxnsCopy = new ArrayList<BaseTransaction>(unstoredTxns);
        this.rollbackTransactions(unstoredTxnsCopy);
    }

    void rollbackTransactions(Collection<BaseTransaction> txns) {
        for (BaseTransaction txn : txns) {
            try {
                this.processTxnCompletion(txn.getTid(), 7, true);
            }
            catch (IOException ioe) {
                logger.log(32, "could not rollback " + txn, (Throwable)ioe);
            }
            catch (BrokerException be) {
                logger.log(32, "could not rollback " + txn, (Throwable)be);
            }
        }
    }

    abstract void processTxn(BaseTransaction var1) throws IOException, BrokerException;

    abstract TransactionEvent generateEvent(BaseTransaction var1, boolean var2) throws IOException, BrokerException;

    abstract BaseTransaction processTxnCompletion(TransactionUID var1, int var2) throws IOException, BrokerException;

    BaseTransaction processTxnCompletion(TransactionUID tid, int state, boolean fullyComplete) throws IOException, BrokerException {
        if (state == 6) {
            this.playingToMessageStore.add(tid);
            if (Store.getDEBUG()) {
                String msg = this.getPrefix() + " add transaction to  playingToMessageStore. tid=" + tid + " size = " + this.playingToMessageStore.size();
                logger.log(4, msg);
            }
        }
        BaseTransaction existingTxn = null;
        boolean stored = false;
        existingTxn = this.incompleteUnstored.get(tid);
        if (existingTxn == null) {
            existingTxn = this.incompleteStored.get(tid);
            if (existingTxn != null) {
                stored = true;
            } else {
                String msg = this.getPrefix() + " processTxnCompletion: Could not find txn for " + tid;
                logger.log(16, msg);
                throw new BrokerException(msg);
            }
        }
        existingTxn.getTransactionDetails().setState(state);
        if (stored) {
            this.updateStoredState(tid, state);
            if (fullyComplete) {
                this.incompleteStored.remove(tid);
                this.completeStored.put(tid, existingTxn);
            }
        } else if (fullyComplete) {
            this.removeFromIncompleteUnstored(tid);
        }
        this.messageListLogged(existingTxn);
        return existingTxn;
    }

    protected void messageListLogged(BaseTransaction baseTxn) {
        List<TransactionWorkMessage> sentMessages;
        TransactionWork txnWork = baseTxn.getTransactionWork();
        if (txnWork != null && (sentMessages = txnWork.getSentMessages()) != null) {
            this.transactionLogManager.loggedMessageHelper.messageListLogged(sentMessages);
        }
    }

    void updateStoredState(TransactionUID tid, int state) throws IOException, BrokerException {
        this.preparedTxnStore.updateTransactionState(tid, state, true);
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " updated transaction state of stored prepared transaction to " + TransactionState.toString(state);
            logger.log(4, msg);
        }
    }

    void updateStoredCompletion(TransactionUID tid, boolean complete) throws IOException, BrokerException {
        this.preparedTxnStore.updateTransactionCompletion(tid, complete, true);
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " updated completion status of stored transaction to " + complete;
            logger.log(4, msg);
        }
    }

    abstract void replayTransactionEvent(TransactionEvent var1, HashSet var2) throws BrokerException, IOException;
}

