/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.group;

import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.group.MapEntry;
import com.sun.messaging.jmq.jmsserver.service.imq.group.SelectThread;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class WriteThread
extends SelectThread {
    boolean inSelect = false;
    boolean busy = false;
    Object selectLock = new Object();
    int selector_cnt = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNewConnection(IMQIPConnection conn) throws IOException {
        List list = this.pending_connections;
        synchronized (list) {
            this.busy = true;
            super.addNewConnection(conn);
        }
    }

    @Override
    public Hashtable getDebugState() {
        Hashtable ht = super.getDebugState();
        ht.put("TYPE", "WriteThread");
        ht.put("busy", this.busy);
        ht.put("inSelect", this.inSelect);
        ht.put("selector_cnt", this.selector_cnt);
        ht.put("WriteThread", String.valueOf(this.hashCode()));
        return ht;
    }

    @Override
    public void changeInterest(SelectionKey key, int mask, String reason) throws IOException {
        super.changeInterest(key, mask, reason);
        this.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wakeup() {
        Object object = this.selectLock;
        synchronized (object) {
            Selector s = this.selector;
            this.busy = true;
            if (this.inSelect && s != null) {
                s.wakeup();
            }
            this.selectLock.notifyAll();
        }
    }

    public WriteThread(Service svc, MapEntry entry) throws IOException {
        super(svc, entry);
        this.type = "write";
        this.INITIAL_KEY = 0;
        this.POSSIBLE_MASK = 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process() throws IOException {
        Object keys;
        this.busy = false;
        Iterator itr = new HashSet(this.all_connections.values()).iterator();
        while (itr.hasNext()) {
            IMQIPConnection con = (IMQIPConnection)itr.next();
            try {
                int ret = con.writeData(false);
                switch (ret) {
                    case 0: {
                        this.busy = true;
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        SelectionKey key = (SelectionKey)this.key_con_map.get(con);
                        key.interestOps(this.POSSIBLE_MASK);
                        ++this.selector_cnt;
                    }
                }
            }
            catch (IOException ex) {
                this.removeConnection(con, ex.toString());
                itr.remove();
            }
        }
        Selector s = this.selector;
        int cnt = 0;
        if (s != null) {
            try {
                cnt = s.selectNow();
            }
            catch (CancelledKeyException key) {
                // empty catch block
            }
        }
        if (cnt > 0) {
            keys = s.selectedKeys();
            Iterator<SelectionKey> keyitr = keys.iterator();
            while (keyitr.hasNext()) {
                this.busy = true;
                SelectionKey key = keyitr.next();
                key.interestOps(this.INITIAL_KEY);
                keyitr.remove();
                --this.selector_cnt;
            }
        }
        keys = this.selectLock;
        synchronized (keys) {
            if (!this.busy) {
                if (this.selector_cnt > 0) {
                    this.inSelect = true;
                } else {
                    try {
                        this.selectLock.wait(this.TIMEOUT);
                    }
                    catch (InterruptedException keyitr) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.inSelect) {
            int selectcnt = 0;
            if (s != null) {
                try {
                    selectcnt = s.select(this.TIMEOUT);
                }
                catch (CancelledKeyException keyitr) {
                    // empty catch block
                }
            }
            if (selectcnt > 0) {
                Set<SelectionKey> keys2 = s.selectedKeys();
                Iterator<SelectionKey> keyitr = keys2.iterator();
                while (keyitr.hasNext()) {
                    this.busy = true;
                    SelectionKey key = keyitr.next();
                    key.interestOps(this.INITIAL_KEY);
                    keyitr.remove();
                    --this.selector_cnt;
                }
            }
        }
        Object object = this.selectLock;
        synchronized (object) {
            this.inSelect = false;
        }
    }
}

