/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.util.List;
import java.util.logging.Level;
import javax.ws.rs.Produces;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.Constants;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.composite.RestModel;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.utils.JsonUtil;

@Provider
@Produces(value={"application/vnd.oracle.glassfish+json"})
public class RestModelWriter
extends BaseProvider<RestModel> {
    public RestModelWriter() {
        super(RestModel.class, Constants.MEDIA_TYPE_JSON_TYPE);
    }

    @Override
    public String getContent(RestModel proxy) {
        StringBuilder sb = new StringBuilder();
        List<String> wrapObjectHeader = ((HttpHeaders)this.requestHeaders.get()).getRequestHeader("X-Wrap-Object");
        boolean wrapObject = wrapObjectHeader != null && wrapObjectHeader.size() > 0;
        try {
            JSONObject object = (JSONObject)JsonUtil.getJsonObject(proxy);
            sb.append(object.toString(this.getFormattingIndentLevel()));
        }
        catch (JSONException ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
        return (wrapObject ? " { item : " : "") + sb.toString() + (wrapObject ? "}" : "");
    }
}

