/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import java.util.HashMap;
import javax.inject.Inject;
import javax.security.auth.Subject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.glassfish.admin.rest.resources.AbstractResource;
import org.glassfish.admin.rest.resources.SessionResource;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.admin.restconnector.RestConfig;
import org.glassfish.common.util.admin.RestSessionManager;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.internal.api.RemoteAdminAccessException;
import org.glassfish.jersey.internal.util.collection.Ref;

@Path(value="/sessions")
public class SessionsResource
extends AbstractResource {
    @Context
    RestSessionManager sessionManager;
    @Inject
    private Ref<Request> request;

    @POST
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    @Produces(value={"application/json;qs=0.5", "application/xml;qs=0.5", "text/html"})
    public Response create(HashMap<String, String> data) {
        if (data == null) {
            data = new HashMap();
        }
        RestConfig restConfig = ResourceUtil.getRestConfig(this.locatorBridge.getRemoteLocator());
        Response.ResponseBuilder responseBuilder = Response.status(Response.Status.UNAUTHORIZED);
        RestActionReporter ar = new RestActionReporter();
        Request grizzlyRequest = (Request)this.request.get();
        String hostName = data.get("remoteHostName");
        boolean isAuthorized = false;
        boolean responseErrorStatusSet = false;
        Subject subject = null;
        try {
            subject = ResourceUtil.authenticateViaAdminRealm(this.locatorBridge.getRemoteLocator(), grizzlyRequest, hostName);
            isAuthorized = ResourceUtil.isAuthorized(this.locatorBridge.getRemoteLocator(), subject, "domain/rest-sessions/rest-session", "create");
        }
        catch (RemoteAdminAccessException e) {
            responseBuilder.status(Response.Status.FORBIDDEN);
            responseErrorStatusSet = true;
        }
        catch (Exception e) {
            ar.setMessage("Error while authenticating " + e);
        }
        if (isAuthorized) {
            responseBuilder.status(Response.Status.OK);
            String username = (String)grizzlyRequest.getAttribute("restUser");
            if (username != null) {
                ar.getExtraProperties().put("username", username);
            }
            ar.getExtraProperties().put("token", this.sessionManager.createSession(grizzlyRequest.getRemoteAddr(), subject, this.chooseTimeout(restConfig)));
        } else if (!responseErrorStatusSet) {
            responseBuilder.status(Response.Status.UNAUTHORIZED);
        }
        return responseBuilder.entity(new ActionReportResult(ar)).build();
    }

    private int chooseTimeout(RestConfig restConfig) {
        int inactiveSessionLifeTime = 30;
        if (restConfig != null) {
            inactiveSessionLifeTime = Integer.parseInt(restConfig.getSessionTokenTimeout());
        }
        return inactiveSessionLifeTime;
    }

    @Path(value="{sessionId}/")
    public SessionResource getSessionResource(@PathParam(value="sessionId") String sessionId) {
        return new SessionResource(this.sessionManager, sessionId, this.requestHeaders, this.uriInfo);
    }
}

