/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.system;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.server.util.Version;
import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.inbound.ActiveInboundResourceAdapterImpl;
import com.sun.enterprise.connectors.jms.JMSLoggerInfo;
import com.sun.enterprise.connectors.jms.config.JmsAvailability;
import com.sun.enterprise.connectors.jms.config.JmsHost;
import com.sun.enterprise.connectors.jms.config.JmsService;
import com.sun.enterprise.connectors.jms.inflow.MdbContainerProps;
import com.sun.enterprise.connectors.jms.system.JMSConfigListener;
import com.sun.enterprise.connectors.jms.system.MQAddressList;
import com.sun.enterprise.connectors.jms.util.JmsRaUtil;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.connectors.util.SetMethodAction;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JMSDestinationDefinitionDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.BeanPoolDescriptor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.v3.services.impl.DummyNetworkListener;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.rmi.Naming;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.naming.NamingException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;
import org.glassfish.admin.mbeanserver.JMXStartupService;
import org.glassfish.api.logging.LogHelper;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.connectors.config.AdminObjectResource;
import org.glassfish.connectors.config.ConnectorResource;
import org.glassfish.connectors.config.ResourceAdapterConfig;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.grizzly.LazyServiceInitializer;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
@Singleton
@Named(value="mq-service")
public class ActiveJmsResourceAdapter
extends ActiveInboundResourceAdapterImpl
implements LazyServiceInitializer,
PostConstruct {
    private static final Logger _logger = JMSLoggerInfo.getLogger();
    private final String SETTER = "setProperty";
    private static final String SEPARATOR = "#";
    private static final String MQ_PASS_FILE_PREFIX = "asmq";
    private static final String MQ_PASS_FILE_KEY = "imq.imqcmd.password=";
    public static final String CONNECTION_URL = "ConnectionURL";
    private final String RECONNECTENABLED = "ReconnectEnabled";
    private final String RECONNECTINTERVAL = "ReconnectInterval";
    private final String RECONNECTATTEMPTS = "ReconnectAttempts";
    private static final String GROUPNAME = "GroupName";
    private static final String CLUSTERCONTAINER = "InClusteredContainer";
    public static final String BROKERTYPE = "BrokerType";
    private static final String BROKERINSTANCENAME = "BrokerInstanceName";
    private static final String BROKERBINDADDRESS = "BrokerBindAddress";
    private static final String BROKERPORT = "BrokerPort";
    private static final String BROKERARGS = "BrokerArgs";
    private static final String BROKERHOMEDIR = "BrokerHomeDir";
    private static final String BROKERLIBDIR = "BrokerLibDir";
    private static final String BROKERVARDIR = "BrokerVarDir";
    private static final String BROKERJAVADIR = "BrokerJavaDir";
    private static final String BROKERSTARTTIMEOUT = "BrokerStartTimeOut";
    public static final String ADMINUSERNAME = "AdminUsername";
    public static final String ADMINPASSWORD = "AdminPassword";
    private static final String ADMINPASSFILE = "AdminPassFile";
    private static final String USERNAME = "UserName";
    private static final String PASSWORD = "Password";
    private static final String MQ_PORTMAPPER_BIND = "doBind";
    private static final String MASTERBROKER = "MasterBroker";
    private static final String JMXSERVICEURL = "JMXServiceURL";
    private static final String JMXSERVICEURLLIST = "JMXServiceURLList";
    private static final String JMXCONNECTORENV = "JMXConnectorEnv";
    private static final String USEJNDIRMISERVICEURL = "useJNDIRMIServiceURL";
    private static final String RMIREGISTRYPORT = "RmiRegistryPort";
    private static final String USEEXTERNALRMIREGISTRY = "startRMIRegistry";
    private static final int DEFAULTRMIREGISTRYPORT = 7776;
    private static final int BROKERRMIPORTOFFSET = 100;
    private static final String SSLJMXCONNECTOR = "SslJMXConnector";
    private static final String CONVENTIONAL_CLUSTER__OF_PEER_BROKERS_DB_PREFIX = "imq.cluster.sharecc.persist.jdbc.";
    private static final String ENHANCED_CLUSTER_DB_PREFIX = "imq.persist.jdbc.";
    private static final String HAREQUIRED = "HARequired";
    private static final String CLUSTERID = "ClusterId";
    private static final String BROKERID = "BrokerId";
    private static final String PINGINTERVAL = "PingInterval";
    private static final String DBTYPE = "DBType";
    private static final String DBTYPE_HADB = "hadb";
    private static final String BROKERENABLEHA = "BrokerEnableHA";
    private static final String DB_HADB_PROPS = "DBProps";
    private static final String DB_HADB_USER = "hadb.user";
    private static final String DB_HADB_PASSWORD = "hadb.password";
    private static final String DB_HADB_DRIVERCLASS = "hadb.driverClass";
    private static final String DS_HADB_PROPS = "DSProps";
    private static final String DS_HADB_SERVERLIST = "hadb.serverList";
    private final String CONTAINER = "InAppClientContainer";
    public static final String DESTINATION = "destination";
    public static final String DESTINATION_TYPE = "destinationType";
    private static String SUBSCRIPTION_NAME = "SubscriptionName";
    private static String CLIENT_ID = "ClientID";
    public static final String PHYSICAL_DESTINATION = "Name";
    private static String MAXPOOLSIZE = "EndpointPoolMaxSize";
    private static String MINPOOLSIZE = "EndpointPoolSteadySize";
    private static String RESIZECOUNT = "EndpointPoolResizeCount";
    private static String RESIZETIMEOUT = "EndpointPoolResizeTimeout";
    private static String REDELIVERYCOUNT = "EndpointExceptionRedeliveryAttempts";
    private static String LOWERCASE_REDELIVERYCOUNT = "endpointExceptionRedeliveryAttempts";
    public static final String ADDRESSLIST = "AddressList";
    private static String ADRLIST_BEHAVIOUR = "AddressListBehavior";
    private static String ADRLIST_ITERATIONS = "AddressListIterations";
    private static final String MDBIDENTIFIER = "MdbName";
    public static final String JMS_SERVICE = "mq-service";
    private static final String MCFADDRESSLIST = "MessageServiceAddressList";
    private StringManager sm = StringManager.getManager(ActiveJmsResourceAdapter.class);
    private MQAddressList urlList = null;
    private String addressList;
    private String brkrPort;
    private boolean doBind;
    private static final String DUSERNAME = "User";
    private static final String DPASSWORD = "Password";
    private static final String DSERVERLIST = "ServerList";
    private static final String HADB_CONNECTION_URL_PREFIX = "jdbc:sun:hadb:";
    public static final String EMBEDDED = "EMBEDDED";
    public static final String LOCAL = "LOCAL";
    public static final String REMOTE = "REMOTE";
    public static final String DIRECT = "DIRECT";
    private final String DEFAULT_STORE_POOL_JNDI_NAME = "jdbc/hastore";
    private static String MQRmiPort = System.getProperty("com.sun.enterprise.connectors.system.MQRmiPort");
    private static final String DASRMIPORT = "31099";
    private static final String REVERT_TO_EMBEDDED_PROPERTY = "com.sun.enterprise.connectors.system.RevertToEmbedded";
    private static final String BROKER_RMI_PORT = "com.sun.enterprise.connectors.system.mq.rmiport";
    private static final String DEFAULT_SERVER = "server";
    private static final String DEFAULT_MQ_INSTANCE = "imqbroker";
    public static final String MQ_DIR_NAME = "imq";
    public static final String GRIZZLY_PROXY_PREFIX = "JMS_PROXY_";
    private Properties dbProps = null;
    private Properties dsProps = null;
    private String brokerInstanceName = null;
    private boolean grizzlyListenerInit;
    private Set<String> grizzlyListeners = new HashSet<String>();
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Inject
    private GlassfishNamingManager nm;
    @Inject
    private Provider<JMSConfigListener> jmsConfigListenerProvider;
    @Inject
    private Provider<ServerEnvironmentImpl> serverEnvironmentImplProvider;
    @Inject
    @Named(value="default-instance-name")
    private Provider<AdminService> adminServiceProvider;
    @Inject
    private Provider<Servers> serversProvider;
    private Provider<JmsService> jmsServiceProvider;
    @Inject
    private Provider<ServerContext> serverContextProvider;
    @Inject
    private Provider<ConnectorRuntime> connectorRuntimeProvider;
    @Inject
    private ServiceLocator habitat;
    @Inject
    private ApplicationRegistry appRegistry;
    Domain domain = (Domain)Globals.get(Domain.class);

    public void postConstruct() {
        block2: {
            try {
                JMSConfigListener jmsConfigListener = (JMSConfigListener)this.jmsConfigListenerProvider.get();
                jmsConfigListener.setActiveResourceAdapter(this);
                JmsRaUtil raUtil = new JmsRaUtil();
                raUtil.upgradeIfNecessary();
            }
            catch (Throwable t) {
                if (!_logger.isLoggable(Level.FINE)) break block2;
                _logger.log(Level.FINE, "Cannot upgrade jmsra" + t.getMessage());
            }
        }
    }

    protected void loadRAConfiguration() throws ConnectorRuntimeException {
        if (this.connectorRuntime.isServer()) {
            try {
                this.setLifecycleProperties();
            }
            catch (Exception e) {
                ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
                throw (ConnectorRuntimeException)cre.initCause((Throwable)e);
            }
            this.setMdbContainerProperties();
            this.setJmsServiceProperties(null);
            this.setClusterRABeanProperties();
            this.setAvailabilityProperties();
        } else {
            this.setAppClientRABeanProperties();
        }
        super.loadRAConfiguration();
        this.postRAConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        block13: {
            try {
                JmsService jmsService = this.getJmsService();
                if (!this.connectorRuntime.isServer() || !this.grizzlyListenerInit || jmsService == null || !EMBEDDED.equalsIgnoreCase(jmsService.getType())) break block13;
                GrizzlyService grizzlyService = null;
                try {
                    grizzlyService = (GrizzlyService)Globals.get(GrizzlyService.class);
                }
                catch (MultiException multiException) {
                    // empty catch block
                }
                if (grizzlyService != null) {
                    Set<String> set = this.grizzlyListeners;
                    synchronized (set) {
                        if (this.grizzlyListeners.size() > 0) {
                            String[] listeners;
                            for (String listenerName : listeners = this.grizzlyListeners.toArray(new String[this.grizzlyListeners.size()])) {
                                try {
                                    grizzlyService.removeNetworkProxy(listenerName);
                                    this.grizzlyListeners.remove(listenerName);
                                }
                                catch (Exception e) {
                                    LogHelper.log((Logger)_logger, (Level)Level.WARNING, (String)"AS-JMS-CORE-00009", (Throwable)e, (Object[])new Object[]{listenerName});
                                }
                            }
                        }
                    }
                }
                this.grizzlyListenerInit = false;
            }
            catch (Throwable th) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "AS-JMS-CORE-00010", new Object[]{th.getMessage()});
                }
                throw new RuntimeException(th);
            }
        }
        super.destroy();
    }

    public Set<String> getGrizzlyListeners() {
        return this.grizzlyListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeLazyListener(JmsService jmsService) {
        GrizzlyService grizzlyService;
        if (jmsService != null && EMBEDDED.equalsIgnoreCase(jmsService.getType()) && !this.grizzlyListenerInit && (grizzlyService = (GrizzlyService)Globals.get(GrizzlyService.class)) != null) {
            List<JmsHost> jmsHosts = jmsService.getJmsHost();
            for (JmsHost oneHost : jmsHosts) {
                if (!Boolean.valueOf(oneHost.getLazyInit()).booleanValue() || this.doBind) continue;
                String jmsHost = null;
                jmsHost = oneHost.getHost() != null && "localhost".equals(oneHost.getHost()) ? "0.0.0.0" : oneHost.getHost();
                DummyNetworkListener dummy = new DummyNetworkListener();
                dummy.setPort(oneHost.getPort());
                dummy.setAddress(jmsHost);
                dummy.setType("proxy");
                dummy.setProtocol(JMS_SERVICE);
                dummy.setTransport("tcp");
                String name = GRIZZLY_PROXY_PREFIX + oneHost.getName();
                dummy.setName(name);
                Set<String> set = this.grizzlyListeners;
                synchronized (set) {
                    grizzlyService.createNetworkProxy((NetworkListener)dummy);
                    this.grizzlyListeners.add(name);
                }
                this.grizzlyListenerInit = true;
            }
        }
    }

    protected void startResourceAdapter(BootstrapContext bootstrapContext) throws ResourceAdapterInternalException {
        try {
            if (this.moduleName_.equals("jmsra")) {
                if (this.connectorRuntime.isServer()) {
                    Domain domain = (Domain)Globals.get(Domain.class);
                    ServerContext serverContext = (ServerContext)Globals.get(ServerContext.class);
                    Server server = domain.getServerNamed(serverContext.getInstanceName());
                    JmsService jmsService = (JmsService)server.getConfig().getExtensionByType(JmsService.class);
                    this.initializeLazyListener(jmsService);
                }
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ResourceAdapterInternalException {
                        ActiveJmsResourceAdapter.this.resourceadapter_.start(ActiveJmsResourceAdapter.this.bootStrapContextImpl);
                        return null;
                    }
                });
            } else {
                this.resourceadapter_.start(this.bootStrapContextImpl);
            }
        }
        catch (PrivilegedActionException ex) {
            throw new ResourceAdapterInternalException((Throwable)ex);
        }
    }

    protected Set mergeRAConfiguration(ResourceAdapterConfig raConfig, List<Property> raConfigProps) {
        if (!this.connectorRuntime.isServer()) {
            return super.mergeRAConfiguration(raConfig, raConfigProps);
        }
        Set mergedProps = super.mergeRAConfiguration(raConfig, raConfigProps);
        String brokerType = null;
        for (ConnectorConfigProperty element : mergedProps) {
            if (!element.getName().equals(BROKERTYPE)) continue;
            brokerType = element.getValue();
        }
        boolean cluster = false;
        try {
            cluster = ActiveJmsResourceAdapter.isClustered();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!cluster && (brokerType.equals(LOCAL) || brokerType.equals(EMBEDDED) || brokerType.equals(DIRECT))) {
            Iterator iter = mergedProps.iterator();
            while (iter.hasNext()) {
                ConnectorConfigProperty element = (ConnectorConfigProperty)iter.next();
                if (!element.getName().equals(CONNECTION_URL)) continue;
                iter.remove();
            }
        }
        return mergedProps;
    }

    public void setup() throws ConnectorRuntimeException {
        if (this.connectionDefs_ == null) {
            throw new ConnectorRuntimeException("No Connection Defs defined in the RA.xml");
        }
        if (this.isServer() && !this.isSystemRar(this.moduleName_)) {
            this.createAllConnectorResources();
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Completed Active Resource adapter setup", this.moduleName_);
        }
    }

    private void setAvailabilityProperties() throws ConnectorRuntimeException {
        if (!ActiveJmsResourceAdapter.isClustered()) {
            return;
        }
        try {
            Domain domain = (Domain)Globals.get(Domain.class);
            ServerContext serverContext = (ServerContext)Globals.get(ServerContext.class);
            Server server = domain.getServerNamed(serverContext.getInstanceName());
            JmsService jmsService = (JmsService)server.getConfig().getExtensionByType(JmsService.class);
            if (jmsService.getType().equals(REMOTE)) {
                return;
            }
            AvailabilityService as = server.getConfig().getAvailabilityService();
            if (as == null) {
                if (_logger.isLoggable(Level.FINE)) {
                    ActiveJmsResourceAdapter.logFine("Availability Service is null. Not setting AvailabilityProperties.");
                }
                return;
            }
            boolean useMasterBroker = true;
            if (as.getExtensionByType(JmsAvailability.class) != null && !MASTERBROKER.equalsIgnoreCase(((JmsAvailability)as.getExtensionByType(JmsAvailability.class)).getConfigStoreType())) {
                useMasterBroker = false;
            }
            boolean isJmsAvailabilityEnabled = this.isJMSAvailabilityOn(as);
            if (_logger.isLoggable(Level.FINE)) {
                ActiveJmsResourceAdapter.logFine("Setting AvailabilityProperties .. ");
            }
            if (!useMasterBroker || isJmsAvailabilityEnabled) {
                ConnectorDescriptor cd = this.getDescriptor();
                String clusterName = this.getMQClusterName();
                ConnectorConfigProperty envProp1 = new ConnectorConfigProperty(CLUSTERID, clusterName, "Cluster Id", "java.lang.String");
                this.setProperty(cd, envProp1);
                if (this.brokerInstanceName == null) {
                    this.brokerInstanceName = ActiveJmsResourceAdapter.getBrokerInstanceName(jmsService);
                }
                ConnectorConfigProperty envProp2 = new ConnectorConfigProperty(BROKERID, this.brokerInstanceName, "Broker Id", "java.lang.String");
                this.setProperty(cd, envProp2);
                if (isJmsAvailabilityEnabled) {
                    ConnectorConfigProperty envProp3 = new ConnectorConfigProperty(HAREQUIRED, "true", "HA Required", "java.lang.String");
                    this.setProperty(cd, envProp3);
                    ConnectorConfigProperty envProp4 = new ConnectorConfigProperty(BROKERENABLEHA, "true", "BrokerEnableHA flag", "java.lang.Boolean");
                    this.setProperty(cd, envProp4);
                    String nodeHostName = domain.getNodeNamed(server.getNodeRef()).getNodeHost();
                    if (nodeHostName != null) {
                        ConnectorConfigProperty envProp5 = new ConnectorConfigProperty(BROKERBINDADDRESS, nodeHostName, "Broker Bind Address", "java.lang.String");
                        this.setProperty(cd, envProp5);
                    }
                    this.loadDBProperties((JmsAvailability)as.getExtensionByType(JmsAvailability.class), ClusterMode.ENHANCED);
                } else {
                    JmsAvailability jmsAvailability = (JmsAvailability)as.getExtensionByType(JmsAvailability.class);
                    if ("jdbc".equals(jmsAvailability.getMessageStoreType())) {
                        this.loadDBProperties(jmsAvailability, ClusterMode.ENHANCED);
                    }
                    this.loadDBProperties(jmsAvailability, ClusterMode.CONVENTIONAL_OF_PEER_BROKERS);
                }
            } else if ("jdbc".equals(((JmsAvailability)as.getExtensionByType(JmsAvailability.class)).getMessageStoreType())) {
                this.loadDBProperties((JmsAvailability)as.getExtensionByType(JmsAvailability.class), ClusterMode.CONVENTIONAL_WITH_MASTER_BROKER);
            }
        }
        catch (Exception e) {
            ConnectorRuntimeException crex = new ConnectorRuntimeException(e.getMessage());
            throw (ConnectorRuntimeException)crex.initCause((Throwable)e);
        }
    }

    private void loadDBProperties(JmsAvailability jmsAvailability, ClusterMode clusterMode) {
        String prefix = null;
        if (ClusterMode.CONVENTIONAL_WITH_MASTER_BROKER == clusterMode) {
            prefix = ENHANCED_CLUSTER_DB_PREFIX;
        } else if (ClusterMode.CONVENTIONAL_OF_PEER_BROKERS == clusterMode) {
            prefix = CONVENTIONAL_CLUSTER__OF_PEER_BROKERS_DB_PREFIX;
        } else if (ClusterMode.ENHANCED == clusterMode) {
            prefix = ENHANCED_CLUSTER_DB_PREFIX;
        } else {
            if (_logger.isLoggable(Level.FINE)) {
                ActiveJmsResourceAdapter.logFine("Unknown cluster mode: " + clusterMode.name() + ", imq DB properties are not set.");
            }
            return;
        }
        if (this.dbProps == null) {
            this.dbProps = new Properties();
        }
        this.dbProps.setProperty("imq.cluster.clusterid", this.getMQClusterName());
        this.dbProps.setProperty("imq.persist.store", jmsAvailability.getMessageStoreType());
        if (ClusterMode.CONVENTIONAL_WITH_MASTER_BROKER == clusterMode) {
            this.dbProps.setProperty("imq.cluster.nomasterbroker", "false");
        } else {
            this.dbProps.setProperty("imq.cluster.nomasterbroker", "true");
        }
        if (Boolean.valueOf(jmsAvailability.getAvailabilityEnabled()).booleanValue() || "jdbc".equals(jmsAvailability.getMessageStoreType())) {
            this.dbProps.setProperty("imq.brokerid", ActiveJmsResourceAdapter.getBrokerInstanceName(this.getJmsService()));
        }
        String dbVendor = jmsAvailability.getDbVendor();
        String dbuser = jmsAvailability.getDbUsername();
        String dbPassword = jmsAvailability.getDbPassword();
        String dbJdbcUrl = jmsAvailability.getDbUrl();
        this.dbProps.setProperty(prefix + "dbVendor", dbVendor);
        String fullprefix = prefix + dbVendor + ".";
        if (dbuser != null) {
            this.dbProps.setProperty(fullprefix + "user", dbuser);
        }
        if (dbPassword != null) {
            this.dbProps.setProperty(fullprefix + "password", dbPassword);
        }
        List<Property> dbprops = jmsAvailability.getProperty();
        String propertyPrefix = fullprefix + "property.";
        if (dbJdbcUrl != null) {
            if ("derby".equals(dbVendor)) {
                this.dbProps.setProperty(fullprefix + "opendburl", dbJdbcUrl);
            } else {
                this.dbProps.setProperty(propertyPrefix + "url", dbJdbcUrl);
            }
        }
        Iterator<Property> iterator = dbprops.iterator();
        while (iterator.hasNext()) {
            Property obj;
            Property prop = obj = iterator.next();
            String key = prop.getName();
            String value = prop.getValue();
            if (key.startsWith("imq.")) {
                this.dbProps.setProperty(key, value);
                continue;
            }
            this.dbProps.setProperty(propertyPrefix + key, value);
        }
    }

    protected void postRAConfiguration() throws ConnectorRuntimeException {
        try {
            if (this.dbProps == null) {
                this.dbProps = new Properties();
            }
            this.dbProps.setProperty("imq.cluster.dynamicChangeMasterBrokerEnabled", "true");
            Method mthds = this.resourceadapter_.getClass().getMethod("setBrokerProps", Properties.class);
            if (_logger.isLoggable(Level.FINE)) {
                ActiveJmsResourceAdapter.logFine("Setting property:DBProps=" + this.dbProps.toString());
            }
            mthds.invoke((Object)this.resourceadapter_, this.dbProps);
        }
        catch (Exception e) {
            ConnectorRuntimeException crex = new ConnectorRuntimeException(e.getMessage());
            throw (ConnectorRuntimeException)crex.initCause((Throwable)e);
        }
    }

    private boolean isJMSAvailabilityOn(AvailabilityService as) {
        if (as == null) {
            return false;
        }
        JmsAvailability ja = (JmsAvailability)as.getExtensionByType(JmsAvailability.class);
        boolean jmsAvailability = false;
        if (ja != null) {
            jmsAvailability = Boolean.parseBoolean(ja.getAvailabilityEnabled());
        }
        _logger.log(Level.FINE, "JMS availability :: " + jmsAvailability);
        return jmsAvailability;
    }

    private void setLifecycleProperties() throws Exception, ConnectorRuntimeException {
        JmsHost jmsHost;
        String defaultJmsHost = this.getJmsService().getDefaultJmsHost();
        if (_logger.isLoggable(Level.FINE)) {
            ActiveJmsResourceAdapter.logFine("Default JMS Host :: " + defaultJmsHost);
        }
        if ((jmsHost = this.getJmsHost()) != null) {
            String brokerPort;
            JavaConfig javaConfig = (JavaConfig)Globals.get(JavaConfig.class);
            String java_home = javaConfig.getJavaHome();
            String brokerType = this.adjustForDirectMode(this.getJmsService().getType());
            this.brkrPort = brokerPort = jmsHost.getPort();
            String adminUserName = jmsHost.getAdminUserName();
            String adminPassword = JmsRaUtil.getUnAliasedPwd(jmsHost.getAdminPassword());
            List<Property> jmsHostProps = this.getJmsService().getProperty();
            String username = null;
            String password = null;
            if (jmsHostProps != null) {
                for (int i = 0; i < jmsHostProps.size(); ++i) {
                    Property jmsProp = jmsHostProps.get(i);
                    String propName = jmsProp.getName();
                    String propValue = jmsProp.getValue();
                    if ("user-name".equals(propName)) {
                        username = propValue;
                        continue;
                    }
                    if (!"password".equals(propName)) continue;
                    password = propValue;
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                ActiveJmsResourceAdapter.logFine("Broker UserName = " + username);
            }
            this.createMQVarDirectoryIfNecessary();
            String brokerVarDir = this.getMQVarDir();
            String tmpString = this.getJmsService().getStartArgs();
            if (tmpString == null) {
                tmpString = "";
            }
            String brokerArgs = tmpString;
            List<Property> jmsProperties = this.getJmsService().getProperty();
            List<Property> jmsHostProperties = jmsHost.getProperty();
            Properties jmsServiceProp = this.listToProperties(jmsProperties);
            Properties jmsHostProp = this.listToProperties(jmsHostProperties);
            jmsServiceProp.putAll((Map<?, ?>)jmsHostProp);
            if (jmsServiceProp.size() > 0) {
                if (this.dbProps == null) {
                    this.dbProps = new Properties();
                }
                this.dbProps.putAll((Map<?, ?>)jmsServiceProp);
            }
            String brokerHomeDir = this.getBrokerHomeDir();
            String brokerLibDir = this.getBrokerLibDir();
            if (this.brokerInstanceName == null) {
                this.brokerInstanceName = ActiveJmsResourceAdapter.getBrokerInstanceName(this.getJmsService());
            }
            long brokerTimeOut = this.getBrokerTimeOut(this.getJmsService());
            ConnectorDescriptor cd = this.getDescriptor();
            ConnectorConfigProperty envProp1 = new ConnectorConfigProperty(BROKERTYPE, brokerType, "Broker Type", "java.lang.String");
            this.setProperty(cd, envProp1);
            ConnectorConfigProperty envProp2 = new ConnectorConfigProperty(BROKERINSTANCENAME, this.brokerInstanceName, "Broker Instance Name", "java.lang.String");
            this.setProperty(cd, envProp2);
            ConnectorConfigProperty envProp3 = new ConnectorConfigProperty(BROKERPORT, brokerPort, "Broker Port", "java.lang.String");
            this.setProperty(cd, envProp3);
            ConnectorConfigProperty envProp4 = new ConnectorConfigProperty(BROKERARGS, brokerArgs, "Broker Args", "java.lang.String");
            this.setProperty(cd, envProp4);
            ConnectorConfigProperty envProp5 = new ConnectorConfigProperty(BROKERHOMEDIR, brokerHomeDir, "Broker Home Dir", "java.lang.String");
            this.setProperty(cd, envProp5);
            ConnectorConfigProperty envProp14 = new ConnectorConfigProperty(BROKERLIBDIR, brokerLibDir, "Broker Lib Dir", "java.lang.String");
            this.setProperty(cd, envProp14);
            ConnectorConfigProperty envProp6 = new ConnectorConfigProperty(BROKERJAVADIR, java_home, "Broker Java Dir", "java.lang.String");
            this.setProperty(cd, envProp6);
            ConnectorConfigProperty envProp7 = new ConnectorConfigProperty(BROKERVARDIR, brokerVarDir, "Broker Var Dir", "java.lang.String");
            this.setProperty(cd, envProp7);
            ConnectorConfigProperty envProp8 = new ConnectorConfigProperty(BROKERSTARTTIMEOUT, "" + brokerTimeOut, "Broker Start Timeout", "java.lang.String");
            this.setProperty(cd, envProp8);
            ConnectorConfigProperty envProp9 = new ConnectorConfigProperty(ADMINUSERNAME, adminUserName, "Broker admin username", "java.lang.String");
            this.setProperty(cd, envProp9);
            ConnectorConfigProperty envProp10 = new ConnectorConfigProperty(ADMINPASSWORD, adminPassword, "Broker admin password", "java.lang.String");
            this.setProperty(cd, envProp10);
            ConnectorConfigProperty envProp11 = new ConnectorConfigProperty(USERNAME, username, "Broker username", "java.lang.String");
            this.setProperty(cd, envProp11);
            ConnectorConfigProperty envProp12 = new ConnectorConfigProperty("Password", password, "Broker password", "java.lang.String");
            this.setProperty(cd, envProp12);
        }
    }

    private Properties listToProperties(List<Property> props) {
        Properties properties = new Properties();
        if (props != null) {
            for (Property prop : props) {
                String key = prop.getName();
                String value = prop.getValue();
                properties.setProperty(key, value);
            }
        }
        return properties;
    }

    private String adjustForDirectMode(String brokerType) {
        if (!ActiveJmsResourceAdapter.isClustered() && brokerType.equals(EMBEDDED)) {
            String revertToEmbedded = System.getProperty(REVERT_TO_EMBEDDED_PROPERTY);
            if (revertToEmbedded != null && revertToEmbedded.equals("true")) {
                return EMBEDDED;
            }
            return DIRECT;
        }
        return brokerType;
    }

    private long getBrokerTimeOut(JmsService jmsService) {
        long defaultTimeout;
        long timeout = defaultTimeout = 30000L;
        String specifiedTimeOut = jmsService.getInitTimeoutInSeconds();
        if (specifiedTimeOut != null) {
            timeout = (long)Integer.parseInt(specifiedTimeOut) * 1000L;
        }
        return timeout;
    }

    public static String getBrokerInstanceName(JmsService js) {
        ServerEnvironmentImpl serverenv = (ServerEnvironmentImpl)Globals.get(ServerEnvironmentImpl.class);
        Domain domain = (Domain)Globals.get(Domain.class);
        String asInstance = serverenv.getInstanceName();
        String domainName = null;
        if (ActiveJmsResourceAdapter.isClustered()) {
            Server server = domain.getServerNamed(asInstance);
            domainName = server.getCluster().getName();
        } else {
            domainName = serverenv.getDomainName();
        }
        String s = ActiveJmsResourceAdapter.getBrokerInstanceName(domainName, asInstance, js);
        if (_logger.isLoggable(Level.FINE)) {
            ActiveJmsResourceAdapter.logFine("Got broker Instancename as " + s);
        }
        String converted = ActiveJmsResourceAdapter.convertStringToValidMQIdentifier(s);
        if (_logger.isLoggable(Level.FINE)) {
            ActiveJmsResourceAdapter.logFine("converted instance name " + converted);
        }
        return converted;
    }

    public boolean handles(ConnectorDescriptor cd, String moduleName) {
        return ConnectorsUtil.isJMSRA((String)moduleName);
    }

    public void validateActivationSpec(ActivationSpec spec) {
        boolean validate = "true".equals(System.getProperty("validate.jms.ra"));
        if (validate) {
            try {
                spec.validate();
            }
            catch (Exception ex) {
                LogHelper.log((Logger)_logger, (Level)Level.SEVERE, (String)"AS-JMS-CORE-00020", (Throwable)ex, (Object[])new Object[0]);
            }
        }
    }

    private static String getBrokerInstanceName(String asDomain, String asInstance, JmsService js) {
        List<Property> jmsProperties = js.getProperty();
        String instanceName = null;
        String suffix = null;
        if (jmsProperties != null) {
            for (int ii = 0; ii < jmsProperties.size(); ++ii) {
                Property p = jmsProperties.get(ii);
                String name = p.getName();
                if (name.equals("instance-name")) {
                    instanceName = p.getValue();
                }
                if (name.equals("instance-name-suffix")) {
                    suffix = p.getValue();
                }
                if (!name.equals("append-version") || !Boolean.valueOf(p.getValue()).booleanValue()) continue;
                suffix = Version.getMajorVersion() + "_" + Version.getMinorVersion();
            }
        }
        if (instanceName != null) {
            return instanceName;
        }
        instanceName = asInstance.equals(DEFAULT_SERVER) ? DEFAULT_MQ_INSTANCE : asDomain + "_" + asInstance;
        if (suffix != null) {
            instanceName = instanceName + "_" + suffix;
        }
        return instanceName;
    }

    private void createMQVarDirectoryIfNecessary() {
        String asInstanceRoot = this.getServerEnvironment().getInitFilePath().getPath();
        String mqInstanceDir = asInstanceRoot + File.separator + MQ_DIR_NAME;
        File instanceDir = new File(mqInstanceDir);
        if (!(instanceDir.exists() && instanceDir.isDirectory() || instanceDir.mkdirs() || !_logger.isLoggable(Level.FINE))) {
            _logger.log(Level.FINE, "Failed to create dir: " + instanceDir);
        }
    }

    private String getMQVarDir() {
        String asInstanceRoot = this.getServerEnvironment().getDomainRoot().getPath();
        String mqInstanceDir = asInstanceRoot + File.separator + MQ_DIR_NAME;
        return mqInstanceDir;
    }

    private String getBrokerLibDir() {
        String brokerLibDir = System.getProperty("com.sun.aas.imqLib");
        if (_logger.isLoggable(Level.FINE)) {
            ActiveJmsResourceAdapter.logFine("broker lib dir from system property " + brokerLibDir);
        }
        return brokerLibDir;
    }

    private String getBrokerHomeDir() {
        String brokerHomeDir = System.getProperty("com.sun.aas.imqBin");
        if (_logger.isLoggable(Level.FINE)) {
            ActiveJmsResourceAdapter.logFine("broker home dir from system property " + brokerHomeDir);
        }
        if (brokerHomeDir == null) {
            String IMQ_INSTALL_SUBDIR = File.separator + ".." + File.separator + ".." + File.separator + MQ_DIR_NAME;
            brokerHomeDir = this.getServerEnvironment().getDomainRoot() + IMQ_INSTALL_SUBDIR;
        } else {
            brokerHomeDir = brokerHomeDir + File.separator + "..";
        }
        if (_logger.isLoggable(Level.FINE)) {
            ActiveJmsResourceAdapter.logFine("Broker Home Directory :: " + brokerHomeDir);
            ActiveJmsResourceAdapter.logFine("broker home dir finally" + brokerHomeDir);
        }
        return brokerHomeDir;
    }

    private void setClusterRABeanProperties() throws ConnectorRuntimeException {
        ConnectorDescriptor cd = super.getDescriptor();
        try {
            if (ActiveJmsResourceAdapter.isClustered()) {
                JmsService jmsService = (JmsService)Globals.get(JmsService.class);
                String val = this.getGroupName();
                ConnectorConfigProperty envProp = new ConnectorConfigProperty(GROUPNAME, val, "Group Name", "java.lang.String");
                this.setProperty(cd, envProp);
                if (_logger.isLoggable(Level.FINE)) {
                    ActiveJmsResourceAdapter.logFine("CLUSTERED instance - setting groupname as" + val);
                }
                boolean inClusteredContainer = false;
                if (jmsService.getType().equals(EMBEDDED) || jmsService.getType().equals(LOCAL)) {
                    inClusteredContainer = true;
                }
                ConnectorConfigProperty envProp1 = new ConnectorConfigProperty(CLUSTERCONTAINER, Boolean.toString(inClusteredContainer), "Cluster container flag", "java.lang.Boolean");
                this.setProperty(cd, envProp1);
                if (_logger.isLoggable(Level.FINE)) {
                    ActiveJmsResourceAdapter.logFine("CLUSTERED instance - setting inclusteredcontainer as" + inClusteredContainer);
                }
                if (jmsService.getType().equals(REMOTE)) {
                    return;
                }
                if (!this.isDBEnabled()) {
                    String masterbrkr = this.getMasterBroker();
                    ConnectorConfigProperty envProp2 = new ConnectorConfigProperty(MASTERBROKER, masterbrkr, "Master  Broker", "java.lang.String");
                    this.setProperty(cd, envProp2);
                    if (_logger.isLoggable(Level.FINE)) {
                        ActiveJmsResourceAdapter.logFine("MASTERBROKER - setting master broker val" + masterbrkr);
                    }
                }
            } else if (_logger.isLoggable(Level.FINE)) {
                ActiveJmsResourceAdapter.logFine("Instance not Clustered and hence not setting groupname");
            }
        }
        catch (Exception e) {
            ConnectorRuntimeException crex = new ConnectorRuntimeException(e.getMessage());
            throw (ConnectorRuntimeException)crex.initCause((Throwable)e);
        }
    }

    private boolean isDBEnabled() {
        ServerContext serverContext;
        Domain domain = (Domain)Globals.get(Domain.class);
        Server server = domain.getServerNamed((serverContext = (ServerContext)Globals.get(ServerContext.class)).getInstanceName());
        AvailabilityService as = server.getConfig().getAvailabilityService();
        if (as != null) {
            JmsAvailability jmsAvailability = (JmsAvailability)as.getExtensionByType(JmsAvailability.class);
            if (jmsAvailability.getAvailabilityEnabled() != null && Boolean.parseBoolean(jmsAvailability.getAvailabilityEnabled())) {
                return true;
            }
            if (jmsAvailability.getConfigStoreType() != null && !"MASTERBROKER".equalsIgnoreCase(jmsAvailability.getConfigStoreType())) {
                return true;
            }
        }
        return false;
    }

    private void setAppClientRABeanProperties() throws ConnectorRuntimeException {
        if (_logger.isLoggable(Level.FINE)) {
            ActiveJmsResourceAdapter.logFine("In Appclient container!!!");
        }
        ConnectorDescriptor cd = super.getDescriptor();
        ConnectorConfigProperty envProp1 = new ConnectorConfigProperty(BROKERTYPE, REMOTE, "Broker Type", "java.lang.String");
        this.setProperty(cd, envProp1);
        ConnectorConfigProperty envProp2 = new ConnectorConfigProperty(GROUPNAME, "", "Group Name", "java.lang.String");
        cd.removeConfigProperty(envProp2);
        ConnectorConfigProperty envProp3 = new ConnectorConfigProperty(CLUSTERCONTAINER, "false", "Cluster flag", "java.lang.Boolean");
        this.setProperty(cd, envProp3);
    }

    private static boolean isClustered() {
        Domain domain = (Domain)Globals.get(Domain.class);
        Clusters clusters = domain.getClusters();
        if (clusters == null) {
            return false;
        }
        List clusterList = clusters.getCluster();
        ServerContext serverctx = (ServerContext)Globals.get(ServerContext.class);
        return JmsRaUtil.isClustered(clusterList, serverctx.getInstanceName());
    }

    private String getGroupName() throws Exception {
        return this.getDomainName() + SEPARATOR + this.getClusterName();
    }

    private String getClusterName() {
        ServerContext serverctx = (ServerContext)Globals.get(ServerContext.class);
        String instanceName = serverctx.getInstanceName();
        Domain domain = (Domain)Globals.get(Domain.class);
        Server server = domain.getServerNamed(instanceName);
        return server.getCluster() != null ? server.getCluster().getName() : null;
    }

    private String getMQClusterName() {
        return ActiveJmsResourceAdapter.convertStringToValidMQIdentifier(this.getClusterName()) + "_MQ";
    }

    private String getMasterBroker() throws Exception {
        return this.urlList.getMasterBroker(this.getClusterName());
    }

    private static String convertStringToValidMQIdentifier(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isLetterOrDigit(s.charAt(i))) continue;
            buf.append(s.charAt(i));
        }
        return buf.toString();
    }

    private String getDomainName() throws Exception {
        return "";
    }

    public void reloadRA(JmsService js) throws ConnectorRuntimeException {
        this.setMdbContainerProperties();
        this.setJmsServiceProperties(js);
        super.loadRAConfiguration();
        this.rebindDescriptor();
    }

    public void addJmsHost(JmsHost host) throws ConnectorRuntimeException {
        this.urlList.addMQUrl(host);
        this.setAddressList();
    }

    public void deleteJmsHost(JmsHost host) throws ConnectorRuntimeException {
        this.urlList.removeMQUrl(host);
        this.setAddressList();
    }

    protected JmsHost getJmsHost() {
        String defaultJmsHost = this.getJmsService().getDefaultJmsHost();
        if (defaultJmsHost == null || defaultJmsHost.equals("")) {
            return (JmsHost)Globals.get(JmsHost.class);
        }
        List<JmsHost> jmsHostsList = this.getJmsService().getJmsHost();
        if (jmsHostsList == null || jmsHostsList.size() == 0) {
            return (JmsHost)Globals.get(JmsHost.class);
        }
        JmsHost jmsHost = null;
        for (int i = 0; i < jmsHostsList.size(); ++i) {
            JmsHost tmpJmsHost = jmsHostsList.get(i);
            if (tmpJmsHost == null || !tmpJmsHost.getName().equals(defaultJmsHost)) continue;
            jmsHost = tmpJmsHost;
            break;
        }
        if (jmsHost == null) {
            jmsHost = jmsHostsList.get(0);
        }
        return jmsHost;
    }

    public void updateJmsHost(JmsHost host) throws ConnectorRuntimeException {
        this.urlList.updateMQUrl(host);
        this.setAddressList();
    }

    public boolean getDoBind() {
        return this.doBind;
    }

    private void setMdbContainerProperties() throws ConnectorRuntimeException {
        JmsRaUtil raUtil = new JmsRaUtil(null);
        ConnectorDescriptor cd = super.getDescriptor();
        raUtil.setMdbContainerProperties();
        String val = "" + MdbContainerProps.getReconnectEnabled();
        ConnectorConfigProperty envProp2 = new ConnectorConfigProperty("ReconnectEnabled", val, val, "java.lang.Boolean");
        this.setProperty(cd, envProp2);
        val = "" + MdbContainerProps.getReconnectDelay();
        ConnectorConfigProperty envProp3 = new ConnectorConfigProperty("ReconnectInterval", val, val, "java.lang.Integer");
        this.setProperty(cd, envProp3);
        val = "" + MdbContainerProps.getReconnectMaxRetries();
        ConnectorConfigProperty envProp4 = new ConnectorConfigProperty("ReconnectAttempts", val, val, "java.lang.Integer");
        this.setProperty(cd, envProp4);
        String integrationMode = this.getJmsService().getType();
        boolean lazyInit = Boolean.valueOf(this.getJmsHost().getLazyInit());
        val = "true";
        if (EMBEDDED.equals(integrationMode) && lazyInit) {
            val = "false";
        }
        this.doBind = Boolean.valueOf(val);
        ConnectorConfigProperty envProp5 = new ConnectorConfigProperty(MQ_PORTMAPPER_BIND, val, val, "java.lang.Boolean");
        this.setProperty(cd, envProp5);
    }

    private void setAddressList() throws ConnectorRuntimeException {
        try {
            JmsService jmsService = (JmsService)Globals.get(JmsService.class);
            this.setConnectionURL(jmsService, this.urlList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.loadRAConfiguration();
    }

    private void setConnectionURL(JmsService jmsService, MQAddressList urlList) {
        ConnectorDescriptor cd = super.getDescriptor();
        String val = urlList.toString();
        if (_logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, "AS-JMS-CORE-00001", new Object[]{val});
        }
        ConnectorConfigProperty envProp1 = new ConnectorConfigProperty(CONNECTION_URL, val, val, "java.lang.String");
        this.setProperty(cd, envProp1);
    }

    private void setJmsServiceProperties(JmsService service) throws ConnectorRuntimeException {
        JmsRaUtil jmsraUtil = new JmsRaUtil(service);
        jmsraUtil.setupAddressList();
        this.urlList = jmsraUtil.getUrlList();
        this.addressList = this.urlList.toString();
        if (_logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, "AS-JMS-CORE-00002", new Object[]{this.addressList});
        }
        ConnectorDescriptor cd = super.getDescriptor();
        this.setConnectionURL(service, this.urlList);
        String val = "" + jmsraUtil.getReconnectEnabled();
        ConnectorConfigProperty envProp2 = new ConnectorConfigProperty("ReconnectEnabled", val, val, "java.lang.Boolean");
        this.setProperty(cd, envProp2);
        int newval = Integer.parseInt(jmsraUtil.getReconnectInterval()) * 1000;
        val = "" + newval;
        ConnectorConfigProperty envProp3 = new ConnectorConfigProperty("ReconnectInterval", val, val, "java.lang.Integer");
        this.setProperty(cd, envProp3);
        val = "" + jmsraUtil.getReconnectAttempts();
        ConnectorConfigProperty envProp4 = new ConnectorConfigProperty("ReconnectAttempts", val, val, "java.lang.Integer");
        this.setProperty(cd, envProp4);
        val = "" + jmsraUtil.getAddressListBehaviour();
        ConnectorConfigProperty envProp5 = new ConnectorConfigProperty(ADRLIST_BEHAVIOUR, val, val, "java.lang.String");
        this.setProperty(cd, envProp5);
        val = "" + jmsraUtil.getAddressListIterations();
        ConnectorConfigProperty envProp6 = new ConnectorConfigProperty(ADRLIST_ITERATIONS, val, val, "java.lang.Integer");
        this.setProperty(cd, envProp6);
        boolean useExternal = this.shouldUseExternalRmiRegistry(jmsraUtil);
        val = Boolean.valueOf(useExternal).toString();
        ConnectorConfigProperty envProp7 = new ConnectorConfigProperty(USEEXTERNALRMIREGISTRY, val, val, "java.lang.Boolean");
        this.setProperty(cd, envProp7);
        _logger.log(Level.FINE, "Start RMI registry set as " + val);
        String configuredRmiRegistryPort = null;
        configuredRmiRegistryPort = !useExternal ? this.getRmiRegistryPort() : this.getUniqueRmiRegistryPort();
        val = configuredRmiRegistryPort;
        if (val != null) {
            ConnectorConfigProperty envProp8 = new ConnectorConfigProperty(RMIREGISTRYPORT, val, val, "java.lang.Integer");
            this.setProperty(cd, envProp8);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "RMI registry port set as " + val);
            }
        } else if (_logger.isLoggable(Level.WARNING)) {
            _logger.log(Level.WARNING, "AS-JMS-CORE-00011");
        }
    }

    private boolean shouldUseExternalRmiRegistry(JmsRaUtil jmsraUtil) {
        boolean useExternalRmiRegistry = !this.isASRmiRegistryPortAvailable(jmsraUtil);
        return useExternalRmiRegistry;
    }

    private String getUniqueRmiRegistryPort() {
        int mqrmiport = 7776;
        try {
            String configuredport = System.getProperty(BROKER_RMI_PORT);
            mqrmiport = configuredport != null ? Integer.parseInt(configuredport) : Integer.parseInt(this.brkrPort) + 100;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "" + mqrmiport;
    }

    private String getRmiRegistryPort() {
        String configuredPort;
        String val;
        block6: {
            val = null;
            if (MQRmiPort != null && !MQRmiPort.trim().equals("")) {
                return MQRmiPort;
            }
            configuredPort = null;
            try {
                configuredPort = this.getConfiguredRmiRegistryPort();
            }
            catch (Exception ex) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "AS-JMS-CORE-00015", new Object[]{ex.getLocalizedMessage()});
                }
                if (!_logger.isLoggable(Level.FINE)) break block6;
                _logger.log(Level.FINE, "Exception while getting configured rmi registry port", ex);
            }
        }
        if (configuredPort != null) {
            return configuredPort;
        }
        if (this.isDAS()) {
            return DASRMIPORT;
        }
        return val;
    }

    private boolean isDAS() {
        return DEFAULT_SERVER.equals(this.getServerContext().getInstanceName());
    }

    private String getConfiguredRmiRegistryHost() throws Exception {
        String hostName = this.getJmxConnector().getAddress();
        if (hostName.equals("") || hostName.equals("0.0.0.0")) {
            try {
                hostName = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                hostName = "localhost";
            }
        } else if (hostName.contains(":") && !hostName.startsWith("[")) {
            return "[" + hostName + "]";
        }
        return hostName;
    }

    private String getConfiguredRmiRegistryPort() throws Exception {
        return this.getJmxConnector().getPort();
    }

    private JmxConnector getJmxConnector() throws Exception {
        List jmxConnectors = this.getAdminService().getJmxConnector();
        String sysJmsConnectorName = this.getAdminService().getSystemJmxConnectorName();
        if (jmxConnectors != null) {
            for (int i = 0; i < jmxConnectors.size(); ++i) {
                if (!sysJmsConnectorName.equals(((JmxConnector)jmxConnectors.get(i)).getName())) continue;
                return (JmxConnector)jmxConnectors.get(i);
            }
        }
        return null;
    }

    private boolean isASRmiRegistryPortAvailable(JmsRaUtil jmsraUtil) {
        if (_logger.isLoggable(Level.FINE)) {
            ActiveJmsResourceAdapter.logFine("isASRmiRegistryPortAvailable - JMSService Type:" + jmsraUtil.getJMSServiceType());
        }
        if (jmsraUtil.getJMSServiceType().equals(REMOTE) || jmsraUtil.getJMSServiceType().equals(LOCAL)) {
            return false;
        }
        try {
            JMXStartupService jmxservice;
            JmxConnector jmxConnector = this.getJmxConnector();
            if (!"true".equals(jmxConnector.getEnabled())) {
                return false;
            }
            if ("true".equals(jmxConnector.getSecurityEnabled())) {
                return false;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Detecting JMXStartupService...");
            }
            if ((jmxservice = (JMXStartupService)Globals.get(JMXStartupService.class)) == null) {
                return false;
            }
            jmxservice.waitUntilJMXConnectorStarted();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Found JMXStartupService");
            }
            String name = "rmi://" + this.getConfiguredRmiRegistryHost() + ":" + this.getConfiguredRmiRegistryPort() + "/jmxrmi";
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Attempting to list " + name);
            }
            Naming.list(name);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("List on " + name + " succeeded");
            }
            return true;
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Failed to detect JMX RMI Registry: " + e.getMessage());
            }
            return false;
        }
    }

    private void setProperty(ConnectorDescriptor cd, ConnectorConfigProperty envProp) {
        cd.removeConfigProperty(envProp);
        cd.addConfigProperty(envProp);
    }

    private void rebindDescriptor() throws ConnectorRuntimeException {
        try {
            String descriptorJNDIName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForDescriptor((String)super.getModuleName());
            this.nm.publishObject(descriptorJNDIName, (Object)super.getDescriptor(), true);
        }
        catch (NamingException ne) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(ne.getMessage());
            throw (ConnectorRuntimeException)cre.initCause((Throwable)ne);
        }
    }

    public ManagedConnectionFactory[] createManagedConnectionFactories(ConnectorConnectionPool cpr, ClassLoader loader) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "RECOVERY : Entering createMCFS in AJMSRA");
        }
        ArrayList<ManagedConnectionFactory> mcfs = new ArrayList<ManagedConnectionFactory>();
        if (this.getAddressListCount() < 2) {
            mcfs.add(this.createManagedConnectionFactory(cpr, loader));
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Brokers are not clustered,So doing normal recovery");
            }
        } else {
            String addlist = null;
            Set s = cpr.getConnectorDescriptorInfo().getMCFConfigProperties();
            for (ConnectorConfigProperty prop : s) {
                String propName = prop.getName();
                if (!propName.equalsIgnoreCase("imqAddressList") && !propName.equalsIgnoreCase("Addresslist")) continue;
                addlist = prop.getValue();
            }
            StringTokenizer tokenizer = null;
            tokenizer = addlist == null || addlist.trim().equalsIgnoreCase("localhost") ? new StringTokenizer(this.addressList, ",") : new StringTokenizer(addlist, ",");
            _logger.log(Level.FINE, "No of addresses found " + tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                String brokerurl = tokenizer.nextToken();
                ManagedConnectionFactory mcf = super.createManagedConnectionFactory(cpr, loader);
                for (ConnectorConfigProperty prop : s) {
                    String propName = prop.getName();
                    String propValue = prop.getValue();
                    if (!propName.startsWith(MQ_DIR_NAME) || "".equals(propValue)) continue;
                    try {
                        Method meth = mcf.getClass().getMethod("setProperty", String.class, String.class);
                        if (propName.trim().equalsIgnoreCase("imqAddressList")) {
                            meth.invoke((Object)mcf, prop.getName(), brokerurl);
                            continue;
                        }
                        meth.invoke((Object)mcf, prop.getName(), prop.getValueObject());
                    }
                    catch (NoSuchMethodException ex) {
                        if (!_logger.isLoggable(Level.WARNING)) continue;
                        _logger.log(Level.WARNING, "AS-JMS-CORE-00012", new Object[]{"setProperty", mcf.getClass().getName()});
                    }
                    catch (Exception ex) {
                        LogHelper.log((Logger)_logger, (Level)Level.SEVERE, (String)"AS-JMS-CORE-00018", (Throwable)ex, (Object[])new Object[]{"setProperty", mcf.getClass().getName()});
                    }
                }
                ConnectorConfigProperty addressProp3 = new ConnectorConfigProperty(ADDRESSLIST, brokerurl, "Address List", "java.lang.String");
                if (_logger.isLoggable(Level.INFO)) {
                    _logger.log(Level.INFO, "AS-JMS-CORE-00003", new Object[]{brokerurl});
                }
                HashSet<ConnectorConfigProperty> addressProp = new HashSet<ConnectorConfigProperty>();
                addressProp.add(addressProp3);
                SetMethodAction setMethodAction = new SetMethodAction((Object)mcf, addressProp);
                try {
                    setMethodAction.run();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                mcfs.add(mcf);
            }
        }
        return mcfs.toArray(new ManagedConnectionFactory[mcfs.size()]);
    }

    protected ManagedConnectionFactory instantiateMCF(final String mcfClass, final ClassLoader loader) throws Exception {
        ManagedConnectionFactory mcf = null;
        if (this.moduleName_.equals("jmsra")) {
            Object tmp = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ActiveJmsResourceAdapter.this.instantiateManagedConnectionFactory(mcfClass, loader);
                }
            });
            mcf = (ManagedConnectionFactory)tmp;
        }
        return mcf;
    }

    private ManagedConnectionFactory instantiateManagedConnectionFactory(String mcfClass, ClassLoader loader) throws Exception {
        return super.instantiateMCF(mcfClass, loader);
    }

    public ManagedConnectionFactory createManagedConnectionFactory(ConnectorConnectionPool cpr, ClassLoader loader) {
        ManagedConnectionFactory mcf;
        block10: {
            mcf = super.createManagedConnectionFactory(cpr, loader);
            if (mcf != null) {
                Set s = cpr.getConnectorDescriptorInfo().getMCFConfigProperties();
                for (ConnectorConfigProperty prop : s) {
                    String propName = prop.getName();
                    if (!propName.startsWith(MQ_DIR_NAME) || "".equals(prop.getValue())) continue;
                    try {
                        Method meth = mcf.getClass().getMethod("setProperty", String.class, String.class);
                        meth.invoke((Object)mcf, prop.getName(), prop.getValueObject());
                    }
                    catch (NoSuchMethodException ex) {
                        if (!_logger.isLoggable(Level.WARNING)) continue;
                        _logger.log(Level.WARNING, "AS-JMS-CORE-00012", new Object[]{"setProperty", mcf.getClass().getName()});
                    }
                    catch (Exception ex) {
                        LogHelper.log((Logger)_logger, (Level)Level.SEVERE, (String)"AS-JMS-CORE-00018", (Throwable)ex, (Object[])new Object[]{"setProperty", mcf.getClass().getName()});
                    }
                }
                String moduleName = this.getModuleName();
                if (ConnectorAdminServiceUtils.isJMSRA((String)moduleName)) {
                    try {
                        Set configProperties = cpr.getConnectorDescriptorInfo().getMCFConfigProperties();
                        Object[] array = configProperties.toArray();
                        for (int i = 0; i < array.length; ++i) {
                            ConnectorConfigProperty property;
                            if (!(array[i] instanceof ConnectorConfigProperty) || !ADDRESSLIST.equals((property = (ConnectorConfigProperty)array[i]).getName()) || property.getValue() != null && !"".equals(property.getValue()) && !"localhost".equals(property.getValue())) continue;
                            _logger.log(Level.FINE, "raraddresslist.default.value : " + property.getValue());
                            configProperties.remove(property);
                        }
                        SetMethodAction setMethodAction = new SetMethodAction((Object)mcf, configProperties);
                        setMethodAction.run();
                    }
                    catch (Exception Ex) {
                        String mcfClass = cpr.getConnectorDescriptorInfo().getManagedConnectionFactoryClass();
                        if (_logger.isLoggable(Level.WARNING)) {
                            _logger.log(Level.WARNING, "AS-JMS-CORE-00014", new Object[]{mcfClass, Ex.getMessage()});
                        }
                        if (!_logger.isLoggable(Level.FINE)) break block10;
                        _logger.log(Level.FINE, "rardeployment.mcfcreation_error", Ex);
                    }
                }
            }
        }
        return mcf;
    }

    public void updateMDBRuntimeInfo(EjbMessageBeanDescriptor descriptor_, BeanPoolDescriptor poolDescriptor) throws ConnectorRuntimeException {
        MessageDestinationDescriptor destDescriptor;
        String jndiName = descriptor_.getJndiName();
        if ((jndiName == null || "".equals(jndiName)) && (destDescriptor = descriptor_.getMessageDestination()) != null) {
            jndiName = destDescriptor.getJndiName();
        }
        String destinationLookup = descriptor_.getActivationConfigValue("destinationLookup");
        String destinationProp = descriptor_.getActivationConfigValue(DESTINATION);
        if (destinationLookup == null && destinationProp == null && (jndiName == null || "".equals(jndiName))) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "AS-JMS-CORE-00019");
            }
            String msg = this.sm.getString("ajra.error_in_dd");
            throw new ConnectorRuntimeException(msg);
        }
        String resourceAdapterMid = "jmsra";
        descriptor_.setResourceAdapterMid(resourceAdapterMid);
        if (destinationLookup == null && destinationProp == null) {
            String appName = descriptor_.getApplication().getAppName();
            String moduleName = ConnectorsUtil.getModuleName((EjbDescriptor)descriptor_);
            JMSDestinationDefinitionDescriptor destination = this.getJMSDestinationFromDescriptor(jndiName, descriptor_);
            String destName = null;
            destName = this.isValidDestination(destination) ? destination.getDestinationName() : this.getPhysicalDestinationFromConfiguration(jndiName, appName, moduleName);
            descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(DESTINATION, destName, null));
            if (descriptor_.getDestinationType() != null && !"".equals(descriptor_.getDestinationType())) {
                descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(DESTINATION_TYPE, descriptor_.getDestinationType(), null));
                if (_logger.isLoggable(Level.INFO)) {
                    _logger.log(Level.INFO, "AS-JMS-CORE-00004", new Object[]{descriptor_.getDestinationType(), jndiName, descriptor_.getName()});
                }
            } else if (this.isValidDestination(destination) && "jmsra".equals(destination.getResourceAdapter())) {
                descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(DESTINATION_TYPE, destination.getInterfaceName(), null));
                if (_logger.isLoggable(Level.INFO)) {
                    _logger.log(Level.INFO, "AS-JMS-CORE-00004", new Object[]{destination.getInterfaceName(), destination.getName(), descriptor_.getName()});
                }
            } else {
                try {
                    AdminObjectResource aor = (AdminObjectResource)ResourcesUtil.createInstance().getResource(jndiName, appName, moduleName, AdminObjectResource.class);
                    if (aor != null && "jmsra".equals(aor.getResAdapter())) {
                        descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(DESTINATION_TYPE, aor.getResType(), null));
                        if (_logger.isLoggable(Level.INFO)) {
                            _logger.log(Level.INFO, "AS-JMS-CORE-00004", new Object[]{aor.getResType(), aor.getJndiName(), descriptor_.getName()});
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(SUBSCRIPTION_NAME, descriptor_.getDurableSubscriptionName(), null));
        String mdbCF = null;
        try {
            mdbCF = descriptor_.getMdbConnectionFactoryJndiName();
        }
        catch (NullPointerException moduleName) {
            // empty catch block
        }
        if (mdbCF != null && !"".equals(mdbCF)) {
            this.setValuesFromConfiguration(mdbCF, descriptor_);
        }
        if (poolDescriptor != null) {
            descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(MAXPOOLSIZE, "" + poolDescriptor.getMaxPoolSize(), "", "java.lang.Integer"));
            descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(MINPOOLSIZE, "" + poolDescriptor.getSteadyPoolSize(), "", "java.lang.Integer"));
            descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(RESIZECOUNT, "" + poolDescriptor.getPoolResizeQuantity(), "", "java.lang.Integer"));
            descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(RESIZETIMEOUT, "" + poolDescriptor.getPoolIdleTimeoutInSeconds(), "", "java.lang.Integer"));
            if (descriptor_.getActivationConfigValue(REDELIVERYCOUNT) == null && descriptor_.getActivationConfigValue(LOWERCASE_REDELIVERYCOUNT) == null) {
                descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(REDELIVERYCOUNT, "" + MdbContainerProps.getMaxRuntimeExceptions(), "", "java.lang.Integer"));
            }
        }
        try {
            boolean clustered = ActiveJmsResourceAdapter.isClustered();
            if (_logger.isLoggable(Level.FINE)) {
                ActiveJmsResourceAdapter.logFine("Are we in a Clustered contained ? " + clustered);
            }
            if (clustered) {
                this.setClusterActivationSpecProperties(descriptor_);
            }
        }
        catch (Exception e) {
            ConnectorRuntimeException crex = new ConnectorRuntimeException(e.getMessage());
            throw (ConnectorRuntimeException)crex.initCause((Throwable)e);
        }
    }

    private void setClusterActivationSpecProperties(EjbMessageBeanDescriptor descriptor_) throws Exception {
        descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(MDBIDENTIFIER, "" + this.getMDBIdentifier((EjbDescriptor)descriptor_), "MDB Identifier", "java.lang.String"));
        if (_logger.isLoggable(Level.FINE)) {
            ActiveJmsResourceAdapter.logFine("CLUSTERED instance - setting MDB identifier as" + this.getMDBIdentifier((EjbDescriptor)descriptor_));
        }
    }

    private String getMDBIdentifier(EjbDescriptor descriptor_) throws Exception {
        return this.getDomainName() + SEPARATOR + this.getClusterName() + SEPARATOR + descriptor_.getUniqueId();
    }

    private String getPhysicalDestinationFromConfiguration(String logicalDest, String appName, String moduleName) throws ConnectorRuntimeException {
        Property ep = null;
        try {
            AdminObjectResource res = null;
            res = (AdminObjectResource)ResourcesUtil.createInstance().getResource(logicalDest, appName, moduleName, AdminObjectResource.class);
            if (res == null) {
                String msg = this.sm.getString("ajra.err_getting_dest", (Object)logicalDest);
                throw new ConnectorRuntimeException(msg);
            }
            ep = res.getProperty(PHYSICAL_DESTINATION);
        }
        catch (Exception ce) {
            String msg = this.sm.getString("ajra.err_getting_dest", (Object)logicalDest);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(msg);
            cre.initCause((Throwable)ce);
            throw cre;
        }
        if (ep == null) {
            String msg = this.sm.getString("ajra.cannot_find_phy_dest", null);
            throw new ConnectorRuntimeException(msg);
        }
        return ep.getValue();
    }

    private JMSDestinationDefinitionDescriptor getJMSDestinationFromDescriptor(String jndiName, EjbMessageBeanDescriptor ejbMessageBeanDescriptor) {
        JMSDestinationDefinitionDescriptor destination = null;
        if (jndiName.startsWith("java:comp/") || !jndiName.startsWith("java:")) {
            destination = this.isEjbInWar(ejbMessageBeanDescriptor) ? this.getJMSDestination(jndiName, ejbMessageBeanDescriptor.getEjbBundleDescriptor().getModuleDescriptor()) : this.getJMSDestination(jndiName, ejbMessageBeanDescriptor);
        } else if (jndiName.startsWith("java:module/")) {
            destination = this.isEjbInWar(ejbMessageBeanDescriptor) ? this.getJMSDestination(jndiName, ejbMessageBeanDescriptor.getEjbBundleDescriptor().getModuleDescriptor()) : this.getJMSDestination(jndiName, ejbMessageBeanDescriptor.getEjbBundleDescriptor());
        } else if (jndiName.startsWith("java:app/")) {
            destination = this.getJMSDestination(jndiName, ejbMessageBeanDescriptor.getApplication());
        } else if (jndiName.startsWith("java:global/") && !this.isValidDestination(destination = this.getJMSDestination(jndiName, ejbMessageBeanDescriptor.getApplication()))) {
            destination = this.getJMSDestination(jndiName);
        }
        if (this.isValidDestination(destination)) {
            return destination;
        }
        return null;
    }

    private boolean isValidDestination(JMSDestinationDefinitionDescriptor descriptor) {
        return descriptor != null && descriptor.getName() != null && !"".equals(descriptor.getName());
    }

    private boolean isEjbInWar(EjbBundleDescriptor ejbBundleDescriptor) {
        RootDeploymentDescriptor rootDeploymentDescriptor = ejbBundleDescriptor.getModuleDescriptor().getDescriptor();
        return rootDeploymentDescriptor != ejbBundleDescriptor && rootDeploymentDescriptor instanceof WebBundleDescriptor;
    }

    private boolean isEjbInWar(EjbMessageBeanDescriptor ejbMessageBeanDescriptor) {
        return this.isEjbInWar(ejbMessageBeanDescriptor.getEjbBundleDescriptor());
    }

    private JMSDestinationDefinitionDescriptor getJMSDestination(String logicalDestination, EjbMessageBeanDescriptor ejbMessageBeanDescriptor) {
        return this.getJMSDestination(logicalDestination, ejbMessageBeanDescriptor.getResourceDescriptors(JavaEEResourceType.JMSDD));
    }

    private JMSDestinationDefinitionDescriptor getJMSDestination(String logicalDestination, EjbBundleDescriptor ejbBundleDescriptor) {
        JMSDestinationDefinitionDescriptor destination = this.getJMSDestination(logicalDestination, ejbBundleDescriptor.getResourceDescriptors(JavaEEResourceType.JMSDD));
        if (this.isValidDestination(destination)) {
            return destination;
        }
        Set ejbDescriptors = ejbBundleDescriptor.getEjbs();
        for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
            destination = this.getJMSDestination(logicalDestination, ejbDescriptor.getResourceDescriptors(JavaEEResourceType.JMSDD));
            if (!this.isValidDestination(destination)) continue;
            return destination;
        }
        return null;
    }

    private JMSDestinationDefinitionDescriptor getJMSDestination(String logicalDestination, ModuleDescriptor moduleDescriptor) {
        WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)moduleDescriptor.getDescriptor();
        JMSDestinationDefinitionDescriptor destination = this.getJMSDestination(logicalDestination, webBundleDescriptor.getResourceDescriptors(JavaEEResourceType.JMSDD));
        if (this.isValidDestination(destination)) {
            return destination;
        }
        Collection ejbBundleDescriptors = moduleDescriptor.getDescriptor().getExtensionsDescriptors(EjbBundleDescriptor.class);
        for (EjbBundleDescriptor ejbBundleDescriptor : ejbBundleDescriptors) {
            destination = this.getJMSDestination(logicalDestination, ejbBundleDescriptor);
            if (!this.isValidDestination(destination)) continue;
            return destination;
        }
        return null;
    }

    private JMSDestinationDefinitionDescriptor getJMSDestination(String logicalDestination, Application application) {
        if (application == null) {
            return null;
        }
        JMSDestinationDefinitionDescriptor destination = this.getJMSDestination(logicalDestination, application.getResourceDescriptors(JavaEEResourceType.JMSDD));
        if (this.isValidDestination(destination)) {
            return destination;
        }
        Set webBundleDescriptors = application.getBundleDescriptors(WebBundleDescriptor.class);
        for (Object webBundleDescriptor : webBundleDescriptors) {
            destination = this.getJMSDestination(logicalDestination, webBundleDescriptor.getResourceDescriptors(JavaEEResourceType.JMSDD));
            if (!this.isValidDestination(destination)) continue;
            return destination;
        }
        Set ejbBundleDescriptors = application.getBundleDescriptors(EjbBundleDescriptor.class);
        for (EjbBundleDescriptor ejbBundleDescriptor : ejbBundleDescriptors) {
            destination = this.getJMSDestination(logicalDestination, ejbBundleDescriptor);
            if (!this.isValidDestination(destination)) continue;
            return destination;
        }
        Set appClientDescriptors = application.getBundleDescriptors(ApplicationClientDescriptor.class);
        for (ApplicationClientDescriptor appClientDescriptor : appClientDescriptors) {
            destination = this.getJMSDestination(logicalDestination, appClientDescriptor.getResourceDescriptors(JavaEEResourceType.JMSDD));
            if (!this.isValidDestination(destination)) continue;
            return destination;
        }
        return null;
    }

    private JMSDestinationDefinitionDescriptor getJMSDestination(String logicalDestination) {
        Domain domain = (Domain)Globals.get(Domain.class);
        Applications applications = domain.getApplications();
        for (com.sun.enterprise.config.serverbeans.Application app : applications.getApplications()) {
            Application application;
            JMSDestinationDefinitionDescriptor destination;
            ApplicationInfo appInfo = this.appRegistry.get(app.getName());
            if (appInfo == null || !this.isValidDestination(destination = this.getJMSDestination(logicalDestination, application = (Application)appInfo.getMetaData(Application.class)))) continue;
            return destination;
        }
        return null;
    }

    private JMSDestinationDefinitionDescriptor getJMSDestination(String jndiName, Set<? extends Descriptor> descriptors) {
        for (Descriptor descriptor : descriptors) {
            if (!(descriptor instanceof JMSDestinationDefinitionDescriptor) || !jndiName.equals(((JMSDestinationDefinitionDescriptor)descriptor).getName())) continue;
            return (JMSDestinationDefinitionDescriptor)descriptor;
        }
        return null;
    }

    private void setValuesFromConfiguration(String cfName, EjbMessageBeanDescriptor descriptor_) throws ConnectorRuntimeException {
        List ep = null;
        try {
            String appName = descriptor_.getApplication().getAppName();
            String moduleName = ConnectorsUtil.getModuleName((EjbDescriptor)descriptor_);
            ConnectorResource res = (ConnectorResource)ResourcesUtil.createInstance().getResource(cfName, appName, moduleName, ConnectorResource.class);
            if (res == null) {
                String msg = this.sm.getString("ajra.mdb_cf_not_created", (Object)cfName);
                throw new ConnectorRuntimeException(msg);
            }
            org.glassfish.connectors.config.ConnectorConnectionPool ccp = (org.glassfish.connectors.config.ConnectorConnectionPool)ResourcesUtil.createInstance().getResource(res.getPoolName(), appName, moduleName, org.glassfish.connectors.config.ConnectorConnectionPool.class);
            ep = ccp.getProperty();
        }
        catch (Exception ce) {
            String msg = this.sm.getString("ajra.mdb_cf_not_created", (Object)cfName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(msg);
            cre.initCause((Throwable)ce);
            throw cre;
        }
        if (ep == null) {
            String msg = this.sm.getString("ajra.cannot_find_phy_dest");
            throw new ConnectorRuntimeException(msg);
        }
        for (int i = 0; i < ep.size(); ++i) {
            String val;
            Property prop = (Property)ep.get(i);
            String name = prop.getName();
            if (name.equals(MCFADDRESSLIST)) {
                name = ADDRESSLIST;
            }
            if ((val = prop.getValue()) == null || val.equals("")) continue;
            descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(name, val, null));
        }
    }

    private static void logFine(String s) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(s);
        }
    }

    public int getAddressListCount() {
        StringTokenizer tokenizer = null;
        int count = 1;
        if (this.addressList != null) {
            tokenizer = new StringTokenizer(this.addressList, ",");
            count = tokenizer.countTokens();
        }
        if (_logger.isLoggable(Level.FINE)) {
            ActiveJmsResourceAdapter.logFine("Address list count is " + count);
        }
        return count;
    }

    private ServerEnvironmentImpl getServerEnvironment() {
        return (ServerEnvironmentImpl)this.serverEnvironmentImplProvider.get();
    }

    private AdminService getAdminService() {
        return (AdminService)this.adminServiceProvider.get();
    }

    private JmsService getJmsService() {
        return (JmsService)this.habitat.getService(JmsService.class, "default-instance-name", new Annotation[0]);
    }

    private ServerContext getServerContext() {
        return (ServerContext)this.serverContextProvider.get();
    }

    public boolean initializeService() {
        try {
            String module = "jmsra";
            String loc = ConnectorsUtil.getSystemModuleLocation((String)module);
            ConnectorRuntime connectorRuntime = (ConnectorRuntime)this.connectorRuntimeProvider.get();
            connectorRuntime.createActiveResourceAdapter(loc, module, null);
            return true;
        }
        catch (ConnectorRuntimeException e) {
            e.printStackTrace();
            e.printStackTrace();
            return false;
        }
    }

    public void handleRequest(SelectableChannel selectableChannel) {
        SocketChannel socketChannel = null;
        if (selectableChannel instanceof SocketChannel) {
            socketChannel = (SocketChannel)selectableChannel;
            try {
                Class<?> c = this.resourceadapter_.getClass();
                Method m = c.getMethod("getPortMapperClientHandler", null);
                Object handler = m.invoke((Object)this.resourceadapter_, null);
                m = handler.getClass().getMethod("handleRequest", SocketChannel.class);
                m.invoke(handler, socketChannel);
            }
            catch (Exception ex) {
                String message = this.sm.getString("error.invoke.portmapper", (Object)ex.getLocalizedMessage());
                throw new RuntimeException(message, ex);
            }
        } else {
            throw new IllegalArgumentException(this.sm.getString("invalid.socket.channel"));
        }
    }

    public void setMasterBroker(String newMasterBroker) {
        block3: {
            try {
                Class<?> c = this.resourceadapter_.getClass();
                Method m = c.getMethod("setMasterBroker", String.class);
                m.invoke((Object)this.resourceadapter_, newMasterBroker);
                if (_logger.isLoggable(Level.INFO)) {
                    _logger.log(Level.INFO, "AS-JMS-CORE-00005", new Object[]{newMasterBroker});
                }
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.INFO)) break block3;
                _logger.log(Level.INFO, "AS-JMS-CORE-00006", new Object[]{newMasterBroker, ex.getMessage()});
            }
        }
    }

    protected void setClusterBrokerList(String brokerList) {
        block3: {
            try {
                Class<?> c = this.resourceadapter_.getClass();
                Method m = c.getMethod("setClusterBrokerList", String.class);
                m.invoke((Object)this.resourceadapter_, brokerList);
                if (_logger.isLoggable(Level.INFO)) {
                    _logger.log(Level.INFO, "AS-JMS-CORE-00007", new Object[]{brokerList});
                }
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.WARNING)) break block3;
                _logger.log(Level.WARNING, "AS-JMS-CORE-00008", new Object[]{brokerList, ex.getMessage()});
            }
        }
    }

    private static enum ClusterMode {
        ENHANCED,
        CONVENTIONAL_WITH_MASTER_BROKER,
        CONVENTIONAL_OF_PEER_BROKERS;

    }
}

