/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.extras.grizzly;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GrizzlyModuleDescriptor {
    private static final String[] HANDLER_ELEMENTS = new String[]{"adapter", "http-handler"};
    static final String DescriptorPath = "META-INF/grizzly-glassfish.xml";
    final Map<String, String> tuples = new HashMap<String, String>();
    final Map<String, ArrayList<GrizzlyProperty>> adapterProperties = new HashMap<String, ArrayList<GrizzlyProperty>>();

    GrizzlyModuleDescriptor(ReadableArchive source, Logger logger) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            this.parse(factory.newDocumentBuilder().parse(source.getEntry(DescriptorPath)));
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    private void parse(Document document) {
        Element element = document.getDocumentElement();
        for (String handlerElement : HANDLER_ELEMENTS) {
            NodeList adapters = element.getElementsByTagName(handlerElement);
            for (int i = 0; i < adapters.getLength(); ++i) {
                Node adapter = adapters.item(i);
                NamedNodeMap attrs = adapter.getAttributes();
                NodeList properties = adapter.getChildNodes();
                ArrayList<GrizzlyProperty> list = new ArrayList<GrizzlyProperty>();
                for (int j = 0; j < properties.getLength(); ++j) {
                    Node property = properties.item(j);
                    NamedNodeMap values = property.getAttributes();
                    if (values == null) continue;
                    list.add(new GrizzlyProperty(values.getNamedItem("name").getNodeValue(), values.getNamedItem("value").getNodeValue()));
                }
                this.adapterProperties.put(attrs.getNamedItem("class-name").getNodeValue(), list);
                this.addAdapter(attrs.getNamedItem("context-root").getNodeValue(), attrs.getNamedItem("class-name").getNodeValue());
            }
        }
    }

    public void addAdapter(String contextRoot, String className) {
        if (this.tuples.containsKey(contextRoot)) {
            throw new RuntimeException("duplicate context root in configuration :" + contextRoot);
        }
        this.tuples.put(contextRoot, className);
    }

    public Map<String, String> getAdapters() {
        return this.tuples;
    }

    Map<String, ArrayList<GrizzlyProperty>> getProperties() {
        return this.adapterProperties;
    }

    static class GrizzlyProperty {
        String name = "";
        String value = "";

        public GrizzlyProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

