/*
 * Decompiled with CFR 0.152.
 */
package com.sun.connector.jaxr;

import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Logger;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ManagedConnection;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;

public class JaxrConnectionEventListener {
    private Vector listeners = new Vector();
    private ManagedConnection mcon;
    @LogMessagesResourceBundle
    private static final Logger log = Logger.getLogger("com.sun.connector.jaxr");

    public JaxrConnectionEventListener(ManagedConnection paramManagedConnection) {
        log.fine("JAXRConnectionEventListener constructor - ManagedConnection as parameter");
        this.mcon = paramManagedConnection;
    }

    public void sendEvent(int paramInt, Exception paramException, Object paramObject) {
        Vector localVector = (Vector)this.listeners.clone();
        ConnectionEvent localConnectionEvent = null;
        log.fine("JAXRConnectionEventListener sendEvent creating connection Event");
        localConnectionEvent = paramException == null ? new ConnectionEvent(this.mcon, paramInt) : new ConnectionEvent(this.mcon, paramInt, paramException);
        if (paramObject != null) {
            log.fine("JAXRConnectionEventListener sendEvent setting connection handle on connection Event");
            localConnectionEvent.setConnectionHandle(paramObject);
        }
        int i = localVector.size();
        block7: for (int j = 0; j < i; ++j) {
            ConnectionEventListener localConnectionEventListener = (ConnectionEventListener)localVector.elementAt(j);
            log.fine("JAXRConnectionEventListener sendEvent processing eventType connection Event");
            switch (paramInt) {
                case 1: {
                    localConnectionEventListener.connectionClosed(localConnectionEvent);
                    log.fine("JAXRConnectionEventListener sendEvent processing Closed eventType --calling listener.closed");
                    continue block7;
                }
                case 2: {
                    localConnectionEventListener.localTransactionStarted(localConnectionEvent);
                    continue block7;
                }
                case 3: {
                    localConnectionEventListener.localTransactionCommitted(localConnectionEvent);
                    continue block7;
                }
                case 4: {
                    localConnectionEventListener.localTransactionRolledback(localConnectionEvent);
                    continue block7;
                }
                case 5: {
                    localConnectionEventListener.connectionErrorOccurred(localConnectionEvent);
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException(ResourceBundle.getBundle("com/sun/connector/jaxr/LocalStrings").getString("Illegal_eventType:_") + paramInt);
                }
            }
        }
    }

    public void addConnectorListener(ConnectionEventListener paramConnectionEventListener) {
        this.listeners.addElement(paramConnectionEventListener);
    }

    public void removeConnectorListener(ConnectionEventListener paramConnectionEventListener) {
        this.listeners.removeElement(paramConnectionEventListener);
    }

    public void connectionClosed(ConnectionEvent paramConnectionEvent) {
        log.fine("JAXRConnectionEventListener connectionClosed - doing nothing");
    }

    public void connectionErrorOccurred(ConnectionEvent paramConnectionEvent) {
        this.sendEvent(5, null, null);
    }
}

