/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.UUID;

public class ClusterNewMasterBrokerPrepareInfo {
    private ArrayList<ChangeRecordInfo> records = null;
    private Long xid = null;
    private String uuid = null;
    private BrokerAddress newmaster = null;
    Cluster c = null;
    private GPacket pkt = null;

    private ClusterNewMasterBrokerPrepareInfo(BrokerAddress newmaster, ArrayList<ChangeRecordInfo> records, Long xid, Cluster c) {
        this.records = records;
        this.xid = xid;
        this.c = c;
        this.newmaster = newmaster;
        this.uuid = UUID.randomUUID().toString();
    }

    private ClusterNewMasterBrokerPrepareInfo(GPacket pkt, Cluster c) {
        this.pkt = pkt;
        this.c = c;
    }

    public static ClusterNewMasterBrokerPrepareInfo newInstance(BrokerAddress newmaster, ArrayList<ChangeRecordInfo> records, Long xid, Cluster c) {
        return new ClusterNewMasterBrokerPrepareInfo(newmaster, records, xid, c);
    }

    public static ClusterNewMasterBrokerPrepareInfo newInstance(GPacket pkt, Cluster c) {
        return new ClusterNewMasterBrokerPrepareInfo(pkt, c);
    }

    public GPacket getGPacket() throws Exception {
        GPacket gp = GPacket.getInstance();
        gp.setType((short)51);
        gp.putProp("TS", System.currentTimeMillis());
        gp.putProp("C", this.records.size());
        gp.putProp("X", this.xid);
        gp.putProp("UUID", this.uuid);
        this.c.marshalBrokerAddress(this.newmaster, gp);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int i = 0; i < this.records.size(); ++i) {
            byte[] rec = this.records.get(i).getRecord();
            bos.write(rec, 0, rec.length);
        }
        bos.flush();
        byte[] buf = bos.toByteArray();
        gp.setPayload(ByteBuffer.wrap(buf));
        gp.setBit(1, true);
        return gp;
    }

    public String getUUID() {
        if (this.pkt != null) {
            return (String)this.pkt.getProp("UUID");
        }
        return this.uuid;
    }

    public BrokerAddress getNewMasterBroker() throws Exception {
        assert (this.pkt != null);
        this.newmaster = this.c.unmarshalBrokerAddress(this.pkt);
        return this.newmaster;
    }

    public int getRecordCount() {
        assert (this.pkt != null);
        return (Integer)this.pkt.getProp("C");
    }

    public Long getXid() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp("X");
    }

    public Long getTimestamp() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp("TS");
    }

    public byte[] getRecords() {
        assert (this.pkt != null);
        byte[] buf = null;
        if (this.pkt.getPayload() != null) {
            buf = this.pkt.getPayload().array();
        }
        return buf;
    }

    public GPacket getReplyGPacket(int status, String reason) {
        assert (this.pkt != null);
        GPacket gp = GPacket.getInstance();
        gp.setType((short)52);
        gp.putProp("X", this.pkt.getProp("X"));
        gp.putProp("S", status);
        if (reason != null) {
            gp.putProp("reason", reason);
        }
        return gp;
    }

    public String toString() {
        if (this.pkt == null) {
            return "[newMasterBroker=" + this.newmaster + ", records=" + this.records.size() + ", xid=" + this.xid + ", uuid=" + this.uuid + "]";
        }
        return (this.newmaster == null ? "" : "[newMasterBroker=" + this.newmaster) + ", records=" + this.getRecordCount() + ", xid=" + this.getXid() + ", ts=" + this.getTimestamp() + ", uuid=" + this.getUUID() + "]";
    }

    public static Long getReplyPacketXid(GPacket gp) {
        return (Long)gp.getProp("X");
    }
}

