/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

class ConfigChangeRecord {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    static final String BASENAME = "configrecord";
    static final int MAGIC = 305419896;
    private ArrayList timeList = new ArrayList();
    private ArrayList recordList = new ArrayList();
    private File backingFile = null;
    private RandomAccessFile raf = null;

    ConfigChangeRecord(File topDir, boolean clear) throws BrokerException {
        try {
            this.backingFile = new File(topDir, BASENAME);
            this.raf = new RandomAccessFile(this.backingFile, "rw");
            if (clear) {
                this.clearAll(false);
                if (Store.getDEBUG()) {
                    this.logger.log(1, "ConfigChangeRecord initialized with clear option");
                }
            } else {
                this.loadData(this.backingFile, this.raf, this.timeList, this.recordList, true);
            }
        }
        catch (IOException e) {
            this.logger.log(32, "B4082", e);
            throw new BrokerException(this.br.getString("B4082"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeConfigChangeRecord(long timestamp, byte[] recordData, boolean sync) throws BrokerException {
        ArrayList arrayList = this.timeList;
        synchronized (arrayList) {
            this.timeList.add(timestamp);
            this.recordList.add(recordData);
            try {
                this.appendFile(timestamp, recordData, sync);
            }
            catch (IOException e) {
                this.timeList.remove(this.timeList.size() - 1);
                this.recordList.remove(this.recordList.size() - 1);
                this.logger.log(32, "B4083", String.valueOf(timestamp));
                throw new BrokerException(this.br.getString("B4083", String.valueOf(timestamp)), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ChangeRecordInfo> getConfigChangeRecordsSince(long timestamp) {
        ArrayList<ChangeRecordInfo> records = new ArrayList<ChangeRecordInfo>();
        ArrayList arrayList = this.timeList;
        synchronized (arrayList) {
            Long stamp;
            int i;
            int size = this.timeList.size();
            for (i = 0; i < size && (stamp = (Long)this.timeList.get(i)) <= timestamp; ++i) {
            }
            while (i < size) {
                records.add(new ChangeRecordInfo((byte[])this.recordList.get(i), (Long)this.timeList.get(i)));
                ++i;
            }
            return records;
        }
    }

    public List<ChangeRecordInfo> getAllConfigRecords() throws BrokerException {
        ArrayList<ChangeRecordInfo> records = new ArrayList<ChangeRecordInfo>();
        for (int i = 0; i < this.timeList.size(); ++i) {
            records.add(new ChangeRecordInfo((byte[])this.recordList.get(i), (Long)this.timeList.get(i)));
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAll(boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(1, "ConfigChangeRecord.clearAll() called");
        }
        ArrayList arrayList = this.timeList;
        synchronized (arrayList) {
            this.timeList.clear();
            this.recordList.clear();
        }
        try {
            this.raf.setLength(0L);
            this.raf.writeInt(305419896);
            if (sync) {
                this.sync();
            }
        }
        catch (IOException e) {
            this.logger.log(32, "B4096", e);
        }
    }

    void close(boolean cleanup) {
        block3: {
            if (Store.getDEBUG()) {
                this.logger.log(1, "ConfigChangeRecord: closing, " + this.timeList.size() + " persisted records");
            }
            try {
                this.raf.close();
            }
            catch (IOException e) {
                if (!Store.getDEBUG()) break block3;
                this.logger.log(4, "Got IOException while closing:" + this.backingFile, e);
                e.printStackTrace();
            }
        }
    }

    Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("Config change records", String.valueOf(this.timeList.size()));
        return t;
    }

    void printInfo(PrintStream out) {
        out.println("\nConfiguration Change Record");
        out.println("---------------------------");
        out.println("backing file: " + this.backingFile);
        out.println("number of records: " + this.timeList.size());
    }

    void sync() throws BrokerException {
        try {
            if (Store.getDEBUG_SYNC()) {
                String msg = "ConfigChangeRecord sync()";
                this.logger.log(4, msg);
            }
            this.raf.getChannel().force(false);
        }
        catch (IOException e) {
            throw new BrokerException("Failed to synchronize file: " + this.backingFile, e);
        }
    }

    private void loadData(File filename, RandomAccessFile dataraf, ArrayList t, ArrayList r, boolean init) throws IOException {
        if (dataraf.length() == 0L) {
            if (init) {
                dataraf.writeInt(305419896);
                if (Store.getDEBUG()) {
                    this.logger.log(1, "initialized new file with magic number, " + filename);
                }
            }
            return;
        }
        this.loadData(filename, dataraf, t, r);
    }

    private void loadData(File filename, RandomAccessFile dataraf, ArrayList t, ArrayList r) throws IOException {
        boolean done = false;
        if (dataraf.length() == 0L) {
            return;
        }
        int magic = dataraf.readInt();
        if (magic != 305419896) {
            throw new StreamCorruptedException(this.br.getString("B3116", filename));
        }
        long pos = dataraf.getFilePointer();
        while (!done) {
            try {
                long timestamp = dataraf.readLong();
                int len = dataraf.readInt();
                byte[] record = new byte[len];
                int cnt = dataraf.read(record, 0, len);
                pos = dataraf.getFilePointer();
                t.add(timestamp);
                r.add(record);
                if (cnt >= 0) continue;
                done = true;
                break;
            }
            catch (EOFException e) {
                if (pos != dataraf.getFilePointer()) {
                    dataraf.setLength(pos);
                    this.logger.log(16, "B2074", (Object)filename, pos);
                }
                done = true;
                break;
            }
            catch (IOException e) {
                this.logger.log(16, "B2073", t.size(), pos, e);
                dataraf.setLength(pos);
                done = true;
                break;
            }
        }
        if (Store.getDEBUG()) {
            this.logger.log(1, "loaded " + t.size() + " records from " + filename);
        }
    }

    private void appendFile(long timestamp, byte[] buf, boolean sync) throws IOException, BrokerException {
        long pos = this.raf.getFilePointer();
        try {
            this.raf.writeLong(timestamp);
            this.raf.writeInt(buf.length);
            this.raf.write(buf);
            if (sync) {
                this.sync();
            }
        }
        catch (IOException e) {
            this.raf.setLength(pos);
            throw e;
        }
        if (Store.getDEBUG()) {
            this.logger.log(4, "configrecord: appended ts=" + timestamp + "; and record of " + buf.length + " bytes to file");
        }
    }
}

