/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.jvnet.hk2.annotations.Service;

@Service
public class DescriptorArchivist {
    @Inject
    protected ArchivistFactory archivistFactory;
    @Inject
    private Provider<ApplicationArchivist> archivistProvider;

    public void write(Application application, ReadableArchive in, WritableArchive out) throws IOException {
        if (application.isVirtual()) {
            ModuleDescriptor<BundleDescriptor> aModule = application.getModules().iterator().next();
            Archivist moduleArchivist = this.archivistFactory.getArchivist(aModule.getModuleType());
            this.write((BundleDescriptor)aModule.getDescriptor(), moduleArchivist, in, out);
        } else {
            for (ModuleDescriptor<BundleDescriptor> aModule : application.getModules()) {
                Archivist moduleArchivist = this.archivistFactory.getArchivist(aModule.getModuleType());
                WritableArchive moduleArchive = out.createSubArchive(aModule.getArchiveUri());
                ReadableArchive moduleArchive2 = in.getSubArchive(aModule.getArchiveUri());
                this.write((BundleDescriptor)aModule.getDescriptor(), moduleArchivist, moduleArchive2, moduleArchive);
            }
            ApplicationArchivist archivist = this.archivistProvider.get();
            archivist.setDescriptor(application);
            archivist.writeDeploymentDescriptors(in, out);
        }
    }

    protected void write(BundleDescriptor bundle, Archivist archivist, ReadableArchive in, WritableArchive out) throws IOException {
        archivist.setDescriptor(bundle);
        archivist.writeDeploymentDescriptors(in, out);
    }
}

